/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.common.client.sse;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.mule.runtime.http.api.sse.ServerSentEvent;
import org.mule.runtime.http.api.sse.client.SseListener;
import org.mule.service.http.common.client.sse.ProgressiveBodyDataListener;
import org.mule.service.http.common.message.sse.SseEventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSentEventDecoder
implements ProgressiveBodyDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSentEventDecoder.class);
    private static final String LINE_BREAK_REGEX = "\\R";
    private final SseEventBuilder eventBuilder = new SseEventBuilder();
    private final SseListener eventListener;
    private String notParsedData = "";
    private CompletableFuture<InputStream> inputStreamFuture = new CompletableFuture();

    public ServerSentEventDecoder(SseListener eventListener) {
        this.eventListener = eventListener;
    }

    @Override
    public void onStreamCreated(InputStream inputStream) {
        if (this.inputStreamFuture.isDone()) {
            throw new IllegalStateException("Another input stream was already added to the event decoder");
        }
        LOGGER.trace("Event stream created");
        this.inputStreamFuture.complete(inputStream);
    }

    @Override
    public void onDataAvailable(int newDataLength) {
        InputStream inputStream = null;
        try {
            inputStream = this.inputStreamFuture.get();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while getting stream in decoder", e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Execution error while getting stream in decoder", e.getCause());
        }
        LOGGER.trace("{} bytes available in the event stream. Reading...", (Object)newDataLength);
        byte[] data = new byte[newDataLength];
        try {
            int actualRead = inputStream.read(data);
            if (actualRead != newDataLength) {
                LOGGER.warn("Expected to read {} bytes from the event stream, but actually read {}", (Object)newDataLength, (Object)actualRead);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception parsing an events stream", e);
        }
        this.notParsedData = this.notParsedData + new String(data);
        String[] lines = this.notParsedData.split(LINE_BREAK_REGEX, -1);
        int linesNumber = lines.length;
        for (int i = 0; i < linesNumber - 1; ++i) {
            LOGGER.trace("Handling line: {}", (Object)lines[i]);
            this.handleLine(lines[i]);
        }
        this.notParsedData = lines[linesNumber - 1];
        LOGGER.trace("Found data after last line separator: {}", (Object)this.notParsedData);
    }

    private void handleLine(String line) {
        if (null == line || line.isEmpty()) {
            ServerSentEvent serverSentEvent = this.eventBuilder.buildAndClear();
            LOGGER.debug("Reading server-sent event: {}", (Object)serverSentEvent);
            this.eventListener.onEvent(serverSentEvent);
        } else if (line.startsWith("data:")) {
            this.eventBuilder.withData(line.substring(5).trim());
        } else if (line.startsWith("event:")) {
            this.eventBuilder.withName(line.substring(6).trim());
        } else if (line.startsWith("id:")) {
            this.eventBuilder.withId(line.substring(3).trim());
        } else if (line.startsWith("retry:")) {
            this.eventBuilder.withRetryDelay(this.parseRetryDelay(line.substring(6).trim()));
        }
    }

    private Long parseRetryDelay(String asString) {
        try {
            return Long.parseLong(asString);
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Failed to parse retry delay because '{}' is not a number", (Object)asString, (Object)e);
            return null;
        }
    }

    @Override
    public void onEndOfStream() {
        LOGGER.trace("End of stream");
        this.eventListener.onClose();
    }
}

