/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.common.server.sse;

import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.runtime.http.api.sse.server.SseRequestContext;
import org.mule.service.http.common.server.sse.FutureCompleterCallback;
import org.mule.service.http.common.server.sse.SseClientImpl;
import org.mule.service.http.common.server.sse.SseRequestContextImpl;

public class SseRequestHandler
implements RequestHandler {
    private static final String SSE_CACHE_CONTROL = "no-cache, no-store, max-age=0, must-revalidate";
    private static final String CORS_WILDCARD = "*";
    private final Consumer<SseRequestContext> onRequest;
    private final Consumer<SseClient> onSseClient;

    public SseRequestHandler(Consumer<SseRequestContext> onRequest, Consumer<SseClient> onSseClient) {
        this.onRequest = onRequest;
        this.onSseClient = onSseClient;
    }

    public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
        SseRequestContextImpl context = new SseRequestContextImpl(requestContext.getRequest(), responseCallback);
        this.onRequest.accept(context);
        if (context.isResponded()) {
            return;
        }
        HttpResponseBuilder responseBuilder = (HttpResponseBuilder)((HttpResponseBuilder)((HttpResponseBuilder)((HttpResponseBuilder)((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).reasonPhrase(HttpConstants.HttpStatus.OK.getReasonPhrase()).addHeader("Content-Type", "text/event-stream")).addHeader("Cache-Control", SSE_CACHE_CONTROL)).addHeader("Pragma", "no-cache")).addHeader("Transfer-Encoding", "chunked")).addHeader("Access-Control-Allow-Origin", CORS_WILDCARD)).entity((HttpEntity)new EmptyHttpEntity());
        HttpResponse sseResponse = responseBuilder.build();
        CompletableFuture<Void> responseSentFuture = new CompletableFuture<Void>();
        Writer bodyWriter = responseCallback.startResponse(sseResponse, (ResponseStatusCallback)new FutureCompleterCallback(responseSentFuture), StandardCharsets.UTF_8);
        SseClientImpl sseClient = new SseClientImpl(bodyWriter, context.getClientId().orElseGet(this::createUUID), responseSentFuture);
        this.onSseClient.accept(sseClient);
    }

    private String createUUID() {
        return UUID.getUUID();
    }
}

