/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.client;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.ssl.SslContext;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.dns.RoundRobinDnsAddressResolverGroup;
import io.qameta.allure.Issue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.auth.HttpAuthenticationType;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.client.InetNoopAddressResolverGroup;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.netty.impl.message.NettyHttpMessage;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.mule.service.http.test.netty.utils.ResponseWithoutHeaders;
import org.mule.service.http.test.netty.utils.server.AuthenticationTestServer;
import org.mule.service.http.test.netty.utils.server.HardcodedResponseTcpServer;
import org.mule.service.http.test.netty.utils.server.TestHttpServer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.PollingProber;

public class NettyHttpClientTestCase
extends AbstractMuleTestCase {
    public static final String WRONG_USERNAME = "failing";
    public static final String WRONG_PASSWORD = "wrong";
    private static final int CONNECTION_IDLE_TIMEOUT = 5000;
    private static final String TEST_USERNAME = "testUsername";
    private static final String TEST_PASSWORD = "testPassword";
    private static final String TEST_DOMAIN = "ntlmDomain";
    private HttpClient client;
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public DynamicPort authServerPort = new DynamicPort("authServerPort");
    @Rule
    public DynamicPort hardcodedServerPort = new DynamicPort("hardcodedServerPort");
    @Rule
    public TestHttpServer testServer = new TestHttpServer("localhost", this.serverPort.getNumber(), false);
    @Rule
    public HardcodedResponseTcpServer hardcodedResponseTcpServer = new HardcodedResponseTcpServer(this.hardcodedServerPort.getNumber());
    @Rule
    public AuthenticationTestServer authTestServer = new AuthenticationTestServer(this.authServerPort.getNumber());
    private Latch serverLatch;

    @Before
    public void setUp() throws Exception {
        this.client = NettyHttpClient.builder().withConnectionIdleTimeout(5000).withUsingPersistentConnections(true).build();
        this.client.start();
        this.testServer.addRequestHandler("/hello", (request, responseSender) -> {
            StringHttpEntity helloContent = new StringHttpEntity("Hello from server!");
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)helloContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.serverLatch = new Latch();
        this.testServer.addRequestHandler("/waitForLatch", (request, responseSender) -> {
            try {
                this.serverLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            StringHttpEntity helloContent = new StringHttpEntity("Hello from server!");
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)helloContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
    }

    @After
    public void tearDown() {
        this.client.stop();
    }

    @Test
    public void sendGetRequestToExistentPath() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/hello", this.serverPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContentAsString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContentAsString, (Matcher)Matchers.is((Object)"Hello from server!"));
    }

    @Test
    public void communityEditionDoesNotSupportWebsockets() {
        HttpRequest httpRequest = HttpRequest.builder().uri(String.format("http://localhost:%d/irrelevant", this.serverPort.getNumber())).method("GET").build();
        WebSocketCallback mockCallback = (WebSocketCallback)Mockito.mock(WebSocketCallback.class);
        UnsupportedOperationException exception = (UnsupportedOperationException)Assert.assertThrows(UnsupportedOperationException.class, () -> this.client.openWebSocket(httpRequest, "mockSocketID", mockCallback));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"WebSockets are only supported in Enterprise Edition"));
    }

    @Test
    public void sendGetRequestToNonExistentPath() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/not-existent", this.serverPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void sendPostRequestToExistentPath() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/hello", this.serverPort.getNumber())).method("POST").entity((HttpEntity)new StringHttpEntity("Hello from client!"))).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContentAsString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContentAsString, (Matcher)Matchers.is((Object)"Hello from server!"));
    }

    @Test
    public void sendPostRequestToNonExistentPath() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/not-existent", this.serverPort.getNumber())).method("POST").entity((HttpEntity)new StringHttpEntity("Hello from client"))).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void connectionIdleTimeout() throws ExecutionException, InterruptedException {
        int shortTimeout = 500;
        NettyHttpClient shortTimeoutClient = NettyHttpClient.builder().withConnectionIdleTimeout(shortTimeout).withUsingPersistentConnections(true).build();
        shortTimeoutClient.start();
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/hello", this.hardcodedServerPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpResponse response = (HttpResponse)shortTimeoutClient.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)this.hardcodedResponseTcpServer.acceptedCount(), (Matcher)Matchers.is((Object)1));
        PollingProber.probe((long)5020L, (long)10L, () -> this.hardcodedResponseTcpServer.acceptedCount() == 0);
        shortTimeoutClient.stop();
    }

    @Test
    public void persistentConnectionTest() throws ExecutionException, InterruptedException {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/hello", this.hardcodedServerPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpResponse response1 = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response1.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)this.hardcodedResponseTcpServer.acceptedCount(), (Matcher)Matchers.is((Object)1));
        Thread.sleep(500L);
        HttpResponse response2 = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response2.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)this.hardcodedResponseTcpServer.acceptedCount(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void responseTimeout() {
        int tooShortTimeout = 30;
        HttpRequest httpRequest = HttpRequest.builder().uri(String.format("http://localhost:%d/waitForLatch", this.serverPort.getNumber())).build();
        CompletableFuture future = this.client.sendAsync(httpRequest, HttpRequestOptions.builder().responseTimeout(tooShortTimeout).build());
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, future::get);
        MatcherAssert.assertThat((Object)executionException.getCause(), (Matcher)Matchers.instanceOf(TimeoutException.class));
        this.serverLatch.release();
    }

    @Test
    public void sendNotEmptyBodyRequest() throws Exception {
        String message = "Hello from client, this is a non streamed request";
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/basic/", this.authServerPort.getNumber())).method("POST").entity((HttpEntity)new StringHttpEntity(message))).build();
        HttpRequestOptions options = HttpRequestOptions.builder().authentication(HttpAuthentication.builder().type(HttpAuthenticationType.BASIC).preemptive(true).username(TEST_USERNAME).password(TEST_PASSWORD).build()).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest, options).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)this.authTestServer.getRequestBody(), (Matcher)Matchers.is((Object)message));
    }

    @Test
    public void sendStreamedRequest() throws Exception {
        String message = "Hello from client, post request to existing path. This is an stream";
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/basic/", this.authServerPort.getNumber())).method("POST").entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8))))).build();
        HttpRequestOptions options = HttpRequestOptions.builder().authentication(HttpAuthentication.builder().type(HttpAuthenticationType.BASIC).preemptive(true).username(TEST_USERNAME).password(TEST_PASSWORD).build()).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest, options).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)this.authTestServer.getRequestBody(), (Matcher)Matchers.is((Object)message));
        String responseBody = this.getBodyFromResponse(response);
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.is((Object)"{\"key1\":\"value1\",\"key2\":\"value2\"}"));
    }

    @Test
    public void sendBasicAuthRequest_preemptive() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/basic/", this.authServerPort.getNumber())).method("POST").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpRequestOptions options = HttpRequestOptions.builder().authentication(HttpAuthentication.builder().type(HttpAuthenticationType.BASIC).preemptive(true).username(TEST_USERNAME).password(TEST_PASSWORD).build()).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest, options).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
    }

    @Test
    public void sendBasicAuthRequest_preemptive_fails() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/basic/", this.authServerPort.getNumber())).method("POST").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpRequestOptions options = HttpRequestOptions.builder().authentication(HttpAuthentication.builder().type(HttpAuthenticationType.BASIC).preemptive(true).username(WRONG_USERNAME).password(WRONG_PASSWORD).build()).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest, options).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
    }

    @Test
    public void sendBasicAuthRequest_nonPreemptive() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/basic", this.authServerPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpRequestOptions options = HttpRequestOptions.builder().authentication(HttpAuthentication.builder().type(HttpAuthenticationType.BASIC).preemptive(false).username(TEST_USERNAME).password(TEST_PASSWORD).build()).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest, options).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
    }

    @Test
    public void sendBasicAuthRequest_nonPreemptive_fails() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/basic", this.authServerPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpRequestOptions options = HttpRequestOptions.builder().authentication(HttpAuthentication.builder().type(HttpAuthenticationType.BASIC).preemptive(false).username(WRONG_USERNAME).password(WRONG_PASSWORD).build()).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest, options).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
    }

    @Test
    public void sendDigestAuthRequest() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/digest", this.authServerPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpRequestOptions options = HttpRequestOptions.builder().authentication(HttpAuthentication.builder().type(HttpAuthenticationType.DIGEST).username(TEST_USERNAME).password(TEST_PASSWORD).build()).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest, options).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
    }

    @Test
    public void sendDigestAuthRequest_fails() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/digest", this.authServerPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpRequestOptions options = HttpRequestOptions.builder().authentication(HttpAuthentication.builder().type(HttpAuthenticationType.DIGEST).username(WRONG_USERNAME).password(WRONG_PASSWORD).build()).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest, options).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
    }

    @Test
    public void sendNtlmAuthRequest() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/ntlm", this.authServerPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpRequestOptions options = HttpRequestOptions.builder().authentication((HttpAuthentication)HttpAuthentication.HttpNtlmAuthentication.builder().type(HttpAuthenticationType.NTLM).username(TEST_USERNAME).password(TEST_PASSWORD).domain(TEST_DOMAIN).build()).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest, options).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
    }

    @Test
    @Issue(value="W-15631618")
    public void testMultipleWWWHeaders_whenBasicAuthenticationIsInvalid_thenServerShouldRespondWithMultipleWWWAuthenticationHeaders() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/multi-auth", this.authServerPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpRequestOptions options = HttpRequestOptions.builder().authentication(HttpAuthentication.builder().type(HttpAuthenticationType.BASIC).preemptive(true).username(WRONG_USERNAME).password(WRONG_PASSWORD).build()).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest, options).get();
        List authenticateHeaders = response.getHeaders().getAll((Object)"www-authenticate");
        MatcherAssert.assertThat((Object)authenticateHeaders, (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Basic realm=\"Test\"")));
        MatcherAssert.assertThat((Object)authenticateHeaders, (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"NTLM")));
        MatcherAssert.assertThat((Object)authenticateHeaders, (Matcher)Matchers.hasItem((Matcher)Matchers.startsWith((String)"Digest realm=\"Test\"")));
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)401));
    }

    @Test
    @Issue(value="W-15631618")
    public void testMultipleWWWHeaders_whenDigestAuthenticationIsInvalid_thenServerShouldRespondWithMultipleWWWAuthenticationHeaders() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/multi-auth", this.authServerPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpRequestOptions options = HttpRequestOptions.builder().authentication(HttpAuthentication.builder().type(HttpAuthenticationType.DIGEST).username(WRONG_USERNAME).password(WRONG_PASSWORD).build()).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest, options).get();
        List authenticateHeaders = response.getHeaders().getAll((Object)"www-authenticate");
        MatcherAssert.assertThat((Object)authenticateHeaders, (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"Basic realm=\"Test\"")));
        MatcherAssert.assertThat((Object)authenticateHeaders, (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"NTLM")));
        MatcherAssert.assertThat((Object)authenticateHeaders, (Matcher)Matchers.hasItem((Matcher)Matchers.startsWith((String)"Digest realm=\"Test\"")));
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)401));
    }

    @Test
    @Issue(value="W-15631618")
    public void testMultipleWWWHeaders_whenAuthenticationIsValid_thenServerShouldRespondWith200() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/multi-auth", this.authServerPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpRequestOptions options = HttpRequestOptions.builder().authentication((HttpAuthentication)HttpAuthentication.HttpNtlmAuthentication.builder().type(HttpAuthenticationType.BASIC).username(TEST_USERNAME).password(TEST_PASSWORD).domain(TEST_DOMAIN).build()).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest, options).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void sendEmptyBodyAndGet_noContentLength() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/emptyBody", this.serverPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        this.testServer.removeAllHandlers();
        this.testServer.addRequestHandler("/emptyBody", (request, responseSender) -> {
            NettyHttpMessage nettyHttpMessage = (NettyHttpMessage)request.getRequest();
            MatcherAssert.assertThat((String)"Content-Length is present when it should be missing", (Object)nettyHttpMessage.containsHeader("Content-Length"), (Matcher)Matchers.is((Object)false));
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)new EmptyHttpEntity()), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        });
        this.client.sendAsync(httpRequest).get();
    }

    @Test
    public void sendEmptyBodyAndPost_contentLengthPresentAndZero() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/emptyBody", this.serverPort.getNumber())).method("POST").entity((HttpEntity)new EmptyHttpEntity())).build();
        this.testServer.removeAllHandlers();
        this.testServer.addRequestHandler("/emptyBody", (request, responseSender) -> {
            NettyHttpMessage nettyHttpMessage = (NettyHttpMessage)request.getRequest();
            MatcherAssert.assertThat((String)"Content-Length is missing when it should be present", (Object)nettyHttpMessage.containsHeader("Content-Length"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((String)"Content-Length should be 0", (Object)Integer.valueOf(nettyHttpMessage.getHeaderValue("Content-Length")), (Matcher)Matchers.is((Object)0));
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)new EmptyHttpEntity()), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        });
        this.client.sendAsync(httpRequest).get();
    }

    @Test
    public void readContentAsSoonFirstChunkReturned() throws Exception {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/basic", this.authServerPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpRequestOptions options = HttpRequestOptions.builder().authentication(HttpAuthentication.builder().type(HttpAuthenticationType.BASIC).preemptive(false).username(TEST_USERNAME).password(TEST_PASSWORD).build()).build();
        ((CompletableFuture)((CompletableFuture)this.client.sendAsync(httpRequest, options).handle((response, exception) -> {
            try {
                return this.getBodyFromResponse((HttpResponse)response);
            }
            catch (IOException | InterruptedException e) {
                throw new CompletionException(e);
            }
        })).whenComplete((result, exception) -> MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)"{\"key1\":\"value1\",\"key2\":\"value2\"}")))).get();
    }

    @Test
    public void maxConnections() throws Exception {
        this.client = NettyHttpClient.builder().withConnectionIdleTimeout(5000).withUsingPersistentConnections(true).withMaxConnections(1).build();
        this.client.start();
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/hello", this.hardcodedServerPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        this.client.sendAsync(httpRequest).get();
        CompletableFuture responseFuture = this.client.sendAsync(httpRequest);
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, responseFuture::get);
        MatcherAssert.assertThat((Object)executionException.getCause(), (Matcher)Matchers.instanceOf(RuntimeException.class));
        MatcherAssert.assertThat((Object)executionException.getCause().getMessage(), (Matcher)Matchers.containsString((String)"Connection limit exceeded, cannot process request"));
    }

    @Test
    public void expectationFailed() throws Exception {
        this.testServer.addRequestHandler("/headerExpectationFailed", (request, responseSender) -> responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.EXPECTATION_FAILED, (HttpEntity)new EmptyHttpEntity()), (ResponseStatusCallback)new NoOpResponseStatusCallback())).start();
        HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/headerExpectationFailed", this.serverPort.getNumber())).addHeader("Expect", "wrongValue")).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.EXPECTATION_FAILED.getStatusCode()));
    }

    @Test
    public void requestBodyNotSendOn417() throws Exception {
        this.testServer.addRequestHandler("/headerExpectationFailed", (request, responseSender) -> responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.EXPECTATION_FAILED, (HttpEntity)new EmptyHttpEntity()), (ResponseStatusCallback)new NoOpResponseStatusCallback())).start();
        HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/headerExpectationFailed", this.serverPort.getNumber())).addHeader("Expect", "wrongValue")).method("GET").entity((HttpEntity)new InputStreamHttpEntity(new InputStream(){

            @Override
            public int read() throws IOException {
                throw new IOException("Payload should not be consumed");
            }
        }))).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.EXPECTATION_FAILED.getStatusCode()));
    }

    @Test
    public void requestBodySentAfter100Continue() throws Exception {
        String serverResponse = "Hello from server";
        this.testServer.addRequestHandler("/100Continue", (request, responseSender) -> responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)new StringHttpEntity(serverResponse)), (ResponseStatusCallback)new NoOpResponseStatusCallback())).start();
        HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/100Continue", this.serverPort.getNumber())).addHeader("Expect", HttpHeaderValues.CONTINUE.toString())).method("GET").entity((HttpEntity)new StringHttpEntity("Hello From Client"))).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)this.getBodyFromResponse(response), (Matcher)Matchers.is((Object)serverResponse));
    }

    @Test
    @Issue(value="W-15631467")
    public void testExpectContinueBehavior() throws Exception {
        this.testServer.addRequestHandler("/expectContinue", (request, responseSender) -> {
            if (request.getRequest().getHeaders().containsKey((Object)"Expect")) {
                responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.CONTINUE, (HttpEntity)new EmptyHttpEntity()), (ResponseStatusCallback)new NoOpResponseStatusCallback());
            }
            StringHttpEntity responseContent = new StringHttpEntity("Request processed successfully!");
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)responseContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/expectContinue", this.serverPort.getNumber())).method("POST").addHeader("Expect", "100-continue")).entity((HttpEntity)new StringHttpEntity("This is the body of the request."))).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
        String responseContentAsString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContentAsString, (Matcher)Matchers.is((Object)"Request processed successfully!"));
    }

    @Test
    @Issue(value="W-16935919")
    public void testExpectContinueBehaviorWithTransferEncodingChunked() throws Exception {
        this.testServer.addRequestHandler("/expectContinue", (request, responseSender) -> {
            if (request.getRequest().getHeaders().containsKey((Object)"Expect")) {
                responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.CONTINUE, (HttpEntity)new EmptyHttpEntity()), (ResponseStatusCallback)new NoOpResponseStatusCallback());
            }
            NettyHttpClientTestCase.consumeContentAndRespond(request, responseSender);
        }).start();
        HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/expectContinue", this.serverPort.getNumber())).method("POST").addHeader("Expect", "100-continue")).addHeader("transfer-encoding", "chunked")).entity((HttpEntity)new InputStreamHttpEntity((InputStream)new DummyInputStream(0x4000000)))).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
        String responseContentAsString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContentAsString, (Matcher)Matchers.containsString((String)"Request length"));
    }

    @Test
    @Issue(value="W-17142270")
    public void testExpectContinueBehaviourWithNonStreamingBody() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        final String bodyContent = "This is the body of the streaming request.";
        HttpEntity requestEntity = new HttpEntity(){

            public boolean isStreaming() {
                return false;
            }

            public boolean isComposed() {
                return false;
            }

            public InputStream getContent() {
                return new ByteArrayInputStream(bodyContent.getBytes(StandardCharsets.UTF_8));
            }

            public byte[] getBytes() {
                return bodyContent.getBytes(StandardCharsets.UTF_8);
            }

            public Collection<HttpPart> getParts() {
                return List.of();
            }

            public Optional<Long> getLength() {
                return Optional.of(Long.valueOf(bodyContent.length()));
            }
        };
        this.testServer.addRequestHandler("/100Continue", (request, responseSender) -> {
            if (request.getRequest().getHeaders().containsKey((Object)"Expect")) {
                responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.CONTINUE, (HttpEntity)new EmptyHttpEntity()), (ResponseStatusCallback)new NoOpResponseStatusCallback());
            }
            StringHttpEntity responseContent = new StringHttpEntity("Request processed successfully!");
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)responseContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
            latch.countDown();
        }).start();
        HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/100Continue", this.serverPort.getNumber())).method("POST").addHeader("Expect", "100-continue")).entity(requestEntity)).build();
        CompletableFuture responseFuture = this.client.sendAsync(httpRequest);
        HttpResponse response = (HttpResponse)responseFuture.get();
        latch.await();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
        String responseContentAsString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContentAsString, (Matcher)Matchers.is((Object)"Request processed successfully!"));
    }

    @Test
    @Issue(value="W-16935919")
    public void testExpectContinueBehaviourWithStreamingBody() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        String bodyContent = "This is the body of the request.";
        final ByteArrayInputStream bodyStream = new ByteArrayInputStream(bodyContent.getBytes(StandardCharsets.UTF_8));
        HttpEntity requestEntity = new HttpEntity(){

            public boolean isStreaming() {
                return true;
            }

            public boolean isComposed() {
                return false;
            }

            public InputStream getContent() {
                return bodyStream;
            }

            public byte[] getBytes() {
                return new byte[0];
            }

            public Collection<HttpPart> getParts() {
                return List.of();
            }

            public Optional<Long> getLength() {
                return Optional.empty();
            }
        };
        this.testServer.addRequestHandler("/100Continue", (request, responseSender) -> {
            if (request.getRequest().getHeaders().containsKey((Object)"Expect")) {
                responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.CONTINUE, (HttpEntity)new EmptyHttpEntity()), (ResponseStatusCallback)new NoOpResponseStatusCallback());
            }
            StringHttpEntity responseContent = new StringHttpEntity("Request processed successfully!");
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)responseContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
            latch.countDown();
        }).start();
        HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/100Continue", this.serverPort.getNumber())).method("POST").addHeader("Expect", "100-continue")).entity(requestEntity)).build();
        CompletableFuture responseFuture = this.client.sendAsync(httpRequest);
        HttpResponse response = (HttpResponse)responseFuture.get();
        latch.await();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
        String responseContentAsString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContentAsString, (Matcher)Matchers.is((Object)"Request processed successfully!"));
    }

    @Test
    @Issue(value="W-15631467")
    public void testClientClosesConnectionAfter100Continue() throws Exception {
        this.testServer.addRequestHandler("/expectContinue", (request, responseSender) -> {
            if (request.getRequest().getHeaders().containsKey((Object)"Expect")) {
                responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.CONTINUE, (HttpEntity)new EmptyHttpEntity()), (ResponseStatusCallback)new NoOpResponseStatusCallback());
            }
            StringHttpEntity responseContent = new StringHttpEntity("This message should not be sent!");
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)responseContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/expectContinue", this.serverPort.getNumber())).method("POST").addHeader("Expect", "100-continue")).entity((HttpEntity)new StringHttpEntity("This is the body of the request."))).build();
        CompletableFuture responseFuture = this.client.sendAsync(httpRequest);
        responseFuture.cancel(true);
        try {
            responseFuture.get();
            Assert.fail((String)"Expected the client to close the connection and not receive a response");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    @Test
    @Issue(value="W-15631467")
    public void testServerIgnoresExpect100Continue() throws Exception {
        this.testServer.addRequestHandler("/expectContinue", (request, responseSender) -> {
            StringHttpEntity responseContent = new StringHttpEntity("Server ignored 100-continue.");
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)responseContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/expectContinue", this.serverPort.getNumber())).method("POST").addHeader("Expect", "100-continue")).entity((HttpEntity)new StringHttpEntity("This is the body of the request."))).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
        String responseContentAsString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContentAsString, (Matcher)Matchers.is((Object)"Server ignored 100-continue."));
    }

    @Test
    @Issue(value="W-15631467")
    public void testServerRejectsWith417ExpectationFailed() throws Exception {
        this.testServer.addRequestHandler("/expectContinue", (request, responseSender) -> {
            StringHttpEntity responseContent = new StringHttpEntity("Expectation failed.");
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.EXPECTATION_FAILED, (HttpEntity)responseContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/expectContinue", this.serverPort.getNumber())).method("POST").addHeader("Expect", "100-continue")).entity((HttpEntity)new StringHttpEntity("This is the body of the request."))).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.EXPECTATION_FAILED.getStatusCode()));
        String responseContentAsString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContentAsString, (Matcher)Matchers.is((Object)"Expectation failed."));
    }

    @Test
    @Issue(value="W-15631467")
    public void testServerSendsErrorAfter100Continue() throws Exception {
        this.testServer.addRequestHandler("/expectContinue", (request, responseSender) -> {
            if (request.getRequest().getHeaders().containsKey((Object)"Expect")) {
                responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.CONTINUE, (HttpEntity)new EmptyHttpEntity()), (ResponseStatusCallback)new NoOpResponseStatusCallback());
            }
            StringHttpEntity errorContent = new StringHttpEntity("Internal Server Error.");
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, (HttpEntity)errorContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/expectContinue", this.serverPort.getNumber())).method("POST").addHeader("Expect", "100-continue")).entity((HttpEntity)new StringHttpEntity("This is the body of the request."))).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(httpRequest).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)500));
        String responseContentAsString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContentAsString, (Matcher)Matchers.is((Object)"Internal Server Error."));
    }

    @Test
    @Issue(value="W-15631467")
    public void testExpectContinueWithNewLineSeparator() throws Exception {
        this.testServer.addRequestHandler("/expectContinue", (request, responseSender) -> {
            if (request.getRequest().getHeaders().containsKey((Object)"Expect")) {
                responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.CONTINUE, (HttpEntity)new EmptyHttpEntity()), (ResponseStatusCallback)new NoOpResponseStatusCallback());
            }
            StringHttpEntity responseContent = new StringHttpEntity("Request processed successfully!");
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)responseContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpRequest httpRequestNewLine = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/expectContinue", this.serverPort.getNumber())).method("POST").addHeader("Expect", "100-continue \n")).entity((HttpEntity)new StringHttpEntity("This is the body of the request using \\n line separator."))).build();
        HttpResponse responseNewLine = (HttpResponse)this.client.sendAsync(httpRequestNewLine).get();
        MatcherAssert.assertThat((Object)responseNewLine.getStatusCode(), (Matcher)Matchers.is((Object)200));
        String responseContentNewLine = IOUtils.toString((InputStream)responseNewLine.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContentNewLine, (Matcher)Matchers.is((Object)"Request processed successfully!"));
    }

    @Test
    @Issue(value="W-15631644")
    public void sendsSeveralLargeRequestStreamInParallel() throws ExecutionException, InterruptedException, IOException {
        int requestLength = 0x3FFFFFFF;
        this.sendMultipleStreamingRequestsInParallel(16, requestLength);
    }

    @Test
    @Issue(value="W-15631644")
    public void sendsManyMediumRequestStreamInParallel() throws ExecutionException, InterruptedException, IOException {
        this.sendMultipleStreamingRequestsInParallel(100, 0x2000000);
    }

    @Test
    @Issue(value="W-17051925")
    public void testResolverGroupWithProxyConfiguredAsTunnel() {
        ProxyConfig proxyConfig = this.mockProxyConfig();
        SslContext sslContext = (SslContext)Mockito.mock(SslContext.class);
        NettyHttpClient clientWithProxyAndSSL = NettyHttpClient.builder().withProxyConfig(proxyConfig).withSslContext(sslContext).withConnectionIdleTimeout(5000).withUsingPersistentConnections(true).build();
        clientWithProxyAndSSL.start();
        AddressResolverGroup resolverGroup = clientWithProxyAndSSL.getResolverGroup();
        MatcherAssert.assertThat((Object)resolverGroup, (Matcher)Matchers.is((Object)InetNoopAddressResolverGroup.INSTANCE));
        clientWithProxyAndSSL.stop();
    }

    @Test
    @Issue(value="W-17051925")
    public void testResolverGroupWithoutProxy() {
        NettyHttpClient clientWithoutProxy = NettyHttpClient.builder().withConnectionIdleTimeout(5000).withUsingPersistentConnections(true).build();
        clientWithoutProxy.start();
        AddressResolverGroup resolverGroup = clientWithoutProxy.getResolverGroup();
        MatcherAssert.assertThat((Object)resolverGroup, (Matcher)Matchers.instanceOf(RoundRobinDnsAddressResolverGroup.class));
        clientWithoutProxy.stop();
    }

    @Test
    @Issue(value="W-15631628")
    public void sendGetRequestRedirected() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/final");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            HttpResponse finalResponse = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(finalResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.GET, "http://localhost:%d/redirect", (HttpEntity)new EmptyHttpEntity()), HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17908187")
    public void sendGetRequestRedirectedWithInitialCookieSent() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/final");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MatcherAssert.assertThat((Object)request.getRequest().getHeaders().containsKey((Object)"Cookie"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((String)request.getRequest().getHeaders().get((Object)"Cookie")).contains("cookie1=value1"), (Matcher)Matchers.is((Object)true));
            HttpResponse finalResponse = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(finalResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpRequest request2 = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/redirect", this.serverPort.getNumber())).method(HttpConstants.Method.GET.name()).entity((HttpEntity)new EmptyHttpEntity())).addHeader("Cookie", "cookie1=value1")).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(request2, HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17847592")
    public void sendPostRequestRedirectShouldBeGetRequestWhen302AndBodyShouldBeRemoved() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            NettyHttpMessage httpMessage = (NettyHttpMessage)request.getRequest();
            MatcherAssert.assertThat((Object)httpMessage.getHeaderValue("Content-Length"), (Matcher)Matchers.is((Object)"31"));
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/final");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MatcherAssert.assertThat((Object)request.getRequest().getMethod(), (Matcher)Matchers.is((Object)HttpMethod.GET.name()));
            NettyHttpMessage nettyHttpMessage = (NettyHttpMessage)request.getRequest();
            MatcherAssert.assertThat((String)"Content-Length should be removed", (Object)nettyHttpMessage.containsHeader(String.valueOf(HttpHeaderNames.TRANSFER_ENCODING)), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)nettyHttpMessage.getHeaderValue("Content-Length"), (Matcher)Matchers.is((Object)"0"));
            HttpResponse temp1Response = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(temp1Response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.POST, "http://localhost:%d/redirect", (HttpEntity)new StringHttpEntity("I should be removed on redirect")), HttpRequestOptions.builder().followsRedirect(true).sendBodyAlways(false).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17847592")
    public void sendPostRequestRedirectShouldBeGetRequestWhen302AndBodyShouldBePreserved() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            NettyHttpMessage httpMessage = (NettyHttpMessage)request.getRequest();
            MatcherAssert.assertThat((Object)httpMessage.getHeaderValue("Content-Length"), (Matcher)Matchers.is((Object)"33"));
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/final");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MatcherAssert.assertThat((Object)request.getRequest().getMethod(), (Matcher)Matchers.is((Object)HttpMethod.GET.name()));
            NettyHttpMessage nettyHttpMessage = (NettyHttpMessage)request.getRequest();
            MatcherAssert.assertThat((Object)nettyHttpMessage.getHeaderValue("Content-Length"), (Matcher)Matchers.is((Object)"33"));
            HttpResponse temp1Response = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(temp1Response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.POST, "http://localhost:%d/redirect", (HttpEntity)new StringHttpEntity("I should be preserved on redirect")), HttpRequestOptions.builder().followsRedirect(true).sendBodyAlways(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17847592")
    public void sendPostRequestRedirectShouldBeGetRequestWhen303() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            NettyHttpMessage httpMessage = (NettyHttpMessage)request.getRequest();
            MatcherAssert.assertThat((Object)httpMessage.getHeaderValue("Content-Length"), (Matcher)Matchers.is((Object)"31"));
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/final");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(303)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MatcherAssert.assertThat((Object)request.getRequest().getMethod(), (Matcher)Matchers.is((Object)HttpMethod.GET.name()));
            HttpResponse temp1Response = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(temp1Response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.POST, "http://localhost:%d/redirect", (HttpEntity)new StringHttpEntity("I should be removed on redirect")), HttpRequestOptions.builder().followsRedirect(true).sendBodyAlways(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17755418")
    public void sendGetRequestRedirectedSeveralTimes() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/temp-1");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/temp-1", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/temp-2");
            HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Temp 1 Destination Reached"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/temp-2", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/temp-3");
            HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Temp 2 Destination Reached"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/temp-3", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/final");
            HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Temp 3 Destination Reached"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            HttpResponse temp1Response = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(temp1Response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.GET, "http://localhost:%d/redirect", (HttpEntity)new EmptyHttpEntity()), HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17755418")
    public void sendGetRequestRedirectedMoreThanMaxRedirectedLimit() {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/temp-1");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/temp-1", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/temp-2");
            HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Temp 1 Destination Reached"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/temp-2", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/temp-3");
            HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Temp 2 Destination Reached"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/temp-3", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/temp-4");
            HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Temp 3 Destination Reached"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/temp-4", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/temp-5");
            HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Temp 4 Destination Reached"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/temp-5", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/final");
            HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Temp 5 Destination Reached"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            HttpResponse temp1Response = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(temp1Response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpRequest httpRequest = this.buildHttpRequest(HttpMethod.GET, "http://localhost:%d/redirect", (HttpEntity)new EmptyHttpEntity());
        CompletableFuture future = this.client.sendAsync(httpRequest, HttpRequestOptions.builder().followsRedirect(true).build());
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, future::get);
        MatcherAssert.assertThat((Object)executionException.getCause(), (Matcher)Matchers.instanceOf(MuleRuntimeException.class));
    }

    @Test
    @Issue(value="W-15631628")
    public void sendGetRequestNotRedirected() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"http://www.example.com/");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.GET, "http://localhost:%d/redirect", (HttpEntity)new EmptyHttpEntity()), HttpRequestOptions.builder().followsRedirect(false).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)302));
        MatcherAssert.assertThat((Object)((String)response.getHeaders().get((Object)"Location")), (Matcher)Matchers.is((Object)"http://www.example.com/"));
    }

    @Test
    @Issue(value="W-17405565")
    public void sendGetRequestShouldRemoveSensitiveHeaders() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/final");
            headers.put((Object)"Authorization", (Object)"Some-value");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MultiMap requestHeaders = request.getRequest().getHeaders();
            MatcherAssert.assertThat((Object)requestHeaders.containsKey((Object)"Authorization"), (Matcher)Matchers.is((Object)false));
            HttpResponse finalResponse = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(finalResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.GET, "http://localhost:%d/redirect", (HttpEntity)new EmptyHttpEntity()), HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17773140")
    public void sendGetRequestOnRedirectPropagatesCookieWithExpiryDateInFuture() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/final");
            headers.put((Object)"Set-Cookie", (Object)"ValidCookie=ValidValue; Expires=Sun, 09 Jun 2030 10:18:14 GMT; Path=/");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MultiMap requestHeaders = request.getRequest().getHeaders();
            MatcherAssert.assertThat((Object)requestHeaders.containsKey((Object)"Cookie"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((String)requestHeaders.get((Object)"Cookie")).contains("ValidCookie=ValidValue"), (Matcher)Matchers.is((Object)true));
            HttpResponse finalResponse = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(finalResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.GET, "http://localhost:%d/redirect", (HttpEntity)new EmptyHttpEntity()), HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17773140")
    public void sendGetRequestOnRedirectPropagatesCookieWithMaxAgeInFuture() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/final");
            headers.put((Object)"Set-Cookie", (Object)"ValidCookie=ValidValue; Max-Age=34560000; Path=/");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MultiMap requestHeaders = request.getRequest().getHeaders();
            MatcherAssert.assertThat((Object)requestHeaders.containsKey((Object)"Cookie"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((String)requestHeaders.get((Object)"Cookie")).contains("ValidCookie=ValidValue"), (Matcher)Matchers.is((Object)true));
            HttpResponse finalResponse = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(finalResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.GET, "http://localhost:%d/redirect", (HttpEntity)new EmptyHttpEntity()), HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17773140")
    public void sendGetRequestOnRedirectRemovesExpiredCookies() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/final");
            headers.put((Object)"Set-Cookie", (Object)"ExpiredCookie=ExpiredValue; Expires=Thu, 01 Jan 1970 00:00:01 GMT; Path=/");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MultiMap requestHeaders = request.getRequest().getHeaders();
            MatcherAssert.assertThat((Object)requestHeaders.containsKey((Object)"Cookie"), (Matcher)Matchers.is((Object)false));
            HttpResponse finalResponse = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(finalResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.GET, "http://localhost:%d/redirect", (HttpEntity)new EmptyHttpEntity()), HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17773140")
    public void sendGetRequestOnRedirectRemovesExpiredCookiesWithMaxAgeNegative() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/final");
            headers.put((Object)"Set-Cookie", (Object)"ExpiredCookie=ExpiredValue; Max-Age=-1; Path=/");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MultiMap requestHeaders = request.getRequest().getHeaders();
            MatcherAssert.assertThat((Object)requestHeaders.containsKey((Object)"Cookie"), (Matcher)Matchers.is((Object)false));
            HttpResponse finalResponse = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(finalResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.GET, "http://localhost:%d/redirect", (HttpEntity)new EmptyHttpEntity()), HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17773140")
    public void sendGetRequestOnRedirectRemovesExpiredCookiesWithMaxAgeZero() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/final");
            headers.put((Object)"Set-Cookie", (Object)"ExpiredCookie=ExpiredValue; Max-Age=0; Path=/");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MultiMap requestHeaders = request.getRequest().getHeaders();
            MatcherAssert.assertThat((Object)requestHeaders.containsKey((Object)"Cookie"), (Matcher)Matchers.is((Object)false));
            HttpResponse finalResponse = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(finalResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.GET, "http://localhost:%d/redirect", (HttpEntity)new EmptyHttpEntity()), HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17773140")
    public void sendGetRequestOnRedirectRemovesExpiredCookiesWithMaxAgeNegativeButExpiresInTheFuture() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/final");
            headers.put((Object)"Set-Cookie", (Object)"ActuallyExpiredCookie=ActuallyExpiredValue; Max-Age=-1; Expires=Thu, 01 Jan 2070 00:00:01 GMT; Path=/");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MultiMap requestHeaders = request.getRequest().getHeaders();
            MatcherAssert.assertThat((Object)requestHeaders.containsKey((Object)"Cookie"), (Matcher)Matchers.is((Object)false));
            HttpResponse finalResponse = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(finalResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.GET, "http://localhost:%d/redirect", (HttpEntity)new EmptyHttpEntity()), HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17773140")
    public void sendGetRequestOnRedirectEachServerRespondsWithSetCookie() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/temp-1");
            headers.put((Object)"Set-Cookie", (Object)"abc=123");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/temp-1", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"final");
            headers.put((Object)"Set-Cookie", (Object)"abc1=1231");
            HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Temp 2 Destination Reached"))).headers(headers)).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MultiMap requestHeaders = request.getRequest().getHeaders();
            MatcherAssert.assertThat((Object)requestHeaders.containsKey((Object)"Cookie"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((String)requestHeaders.get((Object)"Cookie")).contains("abc=123; abc1=1231"), (Matcher)Matchers.is((Object)true));
            HttpResponse temp1Response = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(temp1Response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.GET, "http://localhost:%d/redirect", (HttpEntity)new EmptyHttpEntity()), HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17773140")
    public void sendGetRequestOnRedirectEachServerIncrementsTheCookieValue() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/temp-1");
            headers.put((Object)"Set-Cookie", (Object)"abc=1");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/temp-1", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"final");
            headers.put((Object)"Set-Cookie", (Object)"abc=2");
            HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Temp 2 Destination Reached"))).headers(headers)).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MultiMap requestHeaders = request.getRequest().getHeaders();
            MatcherAssert.assertThat((Object)requestHeaders.containsKey((Object)"Cookie"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((String)requestHeaders.get((Object)"Cookie")).contains("abc=2"), (Matcher)Matchers.is((Object)true));
            HttpResponse temp1Response = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(temp1Response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.GET, "http://localhost:%d/redirect", (HttpEntity)new EmptyHttpEntity()), HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17908187")
    public void sendGetRequestOnRedirectEachServerIncrementsTheCookieValueAndInitialCookieDoesNotGetsUpdated() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/temp-1");
            headers.put((Object)"Set-Cookie", (Object)"abc=1");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/temp-1", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"final");
            headers.put((Object)"Set-Cookie", (Object)"abc=2");
            HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Temp 2 Destination Reached"))).headers(headers)).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MatcherAssert.assertThat((Object)request.getRequest().getHeaders().containsKey((Object)"Cookie"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((String)request.getRequest().getHeaders().get((Object)"Cookie")).contains("abc=2"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((String)request.getRequest().getHeaders().get((Object)"Cookie")).contains("session=123"), (Matcher)Matchers.is((Object)true));
            HttpResponse temp1Response = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(temp1Response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpRequest request2 = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/redirect", this.serverPort.getNumber())).method(HttpMethod.GET.name()).entity((HttpEntity)new EmptyHttpEntity())).addHeaders("Cookie", List.of("session=123"))).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(request2, HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17908187")
    public void sendGetRequestOnRedirectEachServerIncrementsTheCookieValueAndInitialCookieGetsUpdated() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/temp-1");
            headers.put((Object)"Set-Cookie", (Object)"session=456");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/temp-1", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"final");
            headers.put((Object)"Set-Cookie", (Object)"abc=2");
            HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Temp 2 Destination Reached"))).headers(headers)).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MatcherAssert.assertThat((Object)request.getRequest().getHeaders().containsKey((Object)"Cookie"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((String)request.getRequest().getHeaders().get((Object)"Cookie")).contains("abc=2"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((String)request.getRequest().getHeaders().get((Object)"Cookie")).contains("key=123"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((String)request.getRequest().getHeaders().get((Object)"Cookie")).contains("session=456"), (Matcher)Matchers.is((Object)true));
            HttpResponse temp1Response = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(temp1Response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpRequest request2 = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/redirect", this.serverPort.getNumber())).method(HttpMethod.GET.name()).entity((HttpEntity)new EmptyHttpEntity())).addHeaders("Cookie", List.of("abc=0", "key=123"))).build();
        HttpResponse response = (HttpResponse)this.client.sendAsync(request2, HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    @Test
    @Issue(value="W-17773140")
    public void sendGetRequestOnRedirectOnlyFirstServerRespondsWithSetCookie() throws Exception {
        this.testServer.addRequestHandler("/redirect", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"/temp-1");
            headers.put((Object)"Set-Cookie", (Object)"key=value");
            HttpResponse redirectResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Redirecting"))).headers(headers)).statusCode(Integer.valueOf(302)).build();
            responseSender.responseReady(redirectResponse, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/temp-1", (request, responseSender) -> {
            MultiMap headers = new MultiMap();
            headers.put((Object)"Location", (Object)"final");
            HttpResponse response = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Temp 2 Destination Reached"))).headers(headers)).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        this.testServer.addRequestHandler("/final", (request, responseSender) -> {
            MultiMap requestHeaders = request.getRequest().getHeaders();
            MatcherAssert.assertThat((Object)requestHeaders.containsKey((Object)"Cookie"), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((Object)((String)requestHeaders.get((Object)"Cookie")).contains("key=value"), (Matcher)Matchers.is((Object)true));
            HttpResponse temp1Response = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new StringHttpEntity("Final Destination Reached"))).statusCode(Integer.valueOf(200)).build();
            responseSender.responseReady(temp1Response, (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
        HttpResponse response = (HttpResponse)this.client.sendAsync(this.buildHttpRequest(HttpMethod.GET, "http://localhost:%d/redirect", (HttpEntity)new EmptyHttpEntity()), HttpRequestOptions.builder().followsRedirect(true).build()).get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.is((Object)"Final Destination Reached"));
    }

    private HttpRequest buildHttpRequest(HttpMethod method, String path, HttpEntity entity) {
        return ((HttpRequestBuilder)HttpRequest.builder().uri(String.format(path, this.serverPort.getNumber())).method(method.name()).entity(entity)).build();
    }

    private ProxyConfig mockProxyConfig() {
        ProxyConfig proxyConfig = (ProxyConfig)Mockito.mock(ProxyConfig.class);
        Mockito.when((Object)proxyConfig.getHost()).thenReturn((Object)"proxyHost");
        Mockito.when((Object)proxyConfig.getPort()).thenReturn((Object)8080);
        return proxyConfig;
    }

    private void sendMultipleStreamingRequestsInParallel(int requestsNumber, int requestsLength) throws InterruptedException, ExecutionException, IOException {
        ExecutorService executor = Executors.newWorkStealingPool(requestsNumber);
        this.testServer.addRequestHandler("/countBytes", (request, responseSender) -> executor.submit(() -> NettyHttpClientTestCase.consumeContentAndRespond(request, responseSender))).start();
        ArrayList<CompletableFuture> futureList = new ArrayList<CompletableFuture>(requestsNumber);
        for (int i = 0; i < requestsNumber; ++i) {
            HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/countBytes", this.serverPort.getNumber())).method("POST").entity((HttpEntity)new InputStreamHttpEntity((InputStream)new DummyInputStream(requestsLength)))).build();
            futureList.add(this.client.sendAsync(httpRequest));
        }
        for (CompletableFuture future : futureList) {
            HttpResponse response = (HttpResponse)future.get();
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            MatcherAssert.assertThat((Object)this.getBodyFromResponse(response), (Matcher)Matchers.is((Object)("Request length was: " + requestsLength)));
        }
        executor.shutdown();
    }

    private static void consumeContentAndRespond(HttpRequestContext request, HttpResponseReadyCallback responseSender) {
        InputStream content = request.getRequest().getEntity().getContent();
        boolean closed = false;
        byte[] buf = new byte[1024];
        int totalReadBytes = 0;
        while (!closed) {
            try {
                int readBytes = content.read(buf);
                if (readBytes == -1) {
                    closed = true;
                    continue;
                }
                totalReadBytes += readBytes;
            }
            catch (IOException e) {
                closed = true;
            }
        }
        responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)new StringHttpEntity("Request length was: " + totalReadBytes)), (ResponseStatusCallback)new NoOpResponseStatusCallback());
    }

    private String getBodyFromResponse(HttpResponse response) throws IOException, InterruptedException {
        try (InputStream responseInputStream = response.getEntity().getContent();){
            String string = IOUtils.toString((InputStream)responseInputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    private static final class DummyInputStream
    extends InputStream {
        private final int streamLength;
        private int alreadyRead;

        private DummyInputStream(int length) {
            this.streamLength = length;
            this.alreadyRead = 0;
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.alreadyRead == this.streamLength) {
                return -1;
            }
            ++this.alreadyRead;
            return 0;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (this.alreadyRead == this.streamLength) {
                return -1;
            }
            if (this.alreadyRead + len > this.streamLength) {
                int available = this.streamLength - this.alreadyRead;
                this.alreadyRead = this.streamLength;
                return available;
            }
            this.alreadyRead += len;
            return len;
        }
    }
}

