/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.tracer.api.context.SpanContextAware;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public abstract class AbstractEventContext
implements SpanContextAware,
BaseEventContext {
    private static final int STATE_READY = 0;
    private static final int STATE_RESPONSE_RECEIVED = 1;
    private static final int STATE_RESPONSE_PROCESSED = 2;
    private static final int STATE_COMPLETE = 3;
    private static final int STATE_TERMINATED = 4;
    private static final int TO_STRING_TAB_SIZE = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventContext.class);
    private static final FlowExceptionHandler NULL_EXCEPTION_HANDLER = NullExceptionHandler.getInstance();
    private final boolean debugLogEnabled = LOGGER.isDebugEnabled();
    private final transient List<BaseEventContext> childContexts = new ArrayList<BaseEventContext>();
    private final transient FlowExceptionHandler exceptionHandler;
    private final transient CompletableFuture<Void> externalCompletion;
    private transient List<BiConsumer<CoreEvent, Throwable>> onBeforeResponseConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
    private transient List<BiConsumer<CoreEvent, Throwable>> onResponseConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
    private transient List<BiConsumer<CoreEvent, Throwable>> onCompletionConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>(2);
    private transient List<BiConsumer<CoreEvent, Throwable>> onTerminatedConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
    private final ReadWriteLock childContextsReadWriteLock = new ReentrantReadWriteLock();
    private final int depthLevel;
    private byte state = (byte)-1;
    private transient AtomicInteger stateCtx = new AtomicInteger(0);
    private transient AtomicInteger childIdProvider = new AtomicInteger();
    private volatile transient boolean childrenComplete = false;
    private volatile Either<Throwable, CoreEvent> result;
    private LazyValue<ResponsePublisher> responsePublisher = new LazyValue(() -> new ResponsePublisher());
    protected FlowCallStack flowCallStack;

    protected AbstractEventContext() {
        this(NULL_EXCEPTION_HANDLER, 0, Optional.empty());
    }

    protected AbstractEventContext(FlowExceptionHandler exceptionHandler, int depthLevel, Optional<CompletableFuture<Void>> externalCompletion) {
        this.depthLevel = depthLevel;
        this.externalCompletion = externalCompletion.orElse(null);
        if (this.externalCompletion != null) {
            this.externalCompletion.thenAccept(aVoid -> this.tryTerminate());
        }
        this.exceptionHandler = exceptionHandler;
    }

    protected void initCompletionLists() {
        if (this.onBeforeResponseConsumerList == null) {
            this.onBeforeResponseConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
        }
        if (this.onResponseConsumerList == null) {
            this.onResponseConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
        }
        if (this.onCompletionConsumerList == null) {
            this.onCompletionConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>(2);
        }
        if (this.onTerminatedConsumerList == null) {
            this.onTerminatedConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
        }
    }

    void addChildContext(BaseEventContext childContext) {
        this.childContextsReadWriteLock.writeLock().lock();
        try {
            this.childContexts.add(childContext);
        }
        finally {
            this.childContextsReadWriteLock.writeLock().unlock();
        }
    }

    @Override
    public final void success() {
        this.success(null);
    }

    @Override
    public final void success(CoreEvent event) {
        if (this.stateCtx.compareAndSet(0, 1)) {
            if (this.debugLogEnabled) {
                LOGGER.debug("{} response completed with result.", (Object)this);
            }
            this.receiveResponse((Either<Throwable, CoreEvent>)Either.right((Object)event));
        } else if (this.debugLogEnabled) {
            LOGGER.debug("{} response was already completed, ignoring.", (Object)this);
        }
    }

    @Override
    public final Publisher<Void> error(Throwable throwable) {
        if (this.stateCtx.compareAndSet(0, 1)) {
            if (this.debugLogEnabled) {
                LOGGER.debug("{} responseDone completed with error.", (Object)this);
            }
            if (throwable instanceof MessagingException) {
                if (this.debugLogEnabled) {
                    LOGGER.debug("{} handling messaging exception.", (Object)this);
                }
                Consumer<Exception> router = this.exceptionHandler.router((Function<Publisher<CoreEvent>, Publisher<CoreEvent>>)Functions.identity(), this::success, rethrown -> this.receiveResponse((Either<Throwable, CoreEvent>)Either.left((Object)rethrown)));
                try {
                    router.accept((Exception)throwable);
                }
                finally {
                    LifecycleUtils.disposeIfNeeded(router, LOGGER);
                }
            } else {
                this.receiveResponse((Either<Throwable, CoreEvent>)Either.left((Object)throwable));
            }
        } else if (this.debugLogEnabled) {
            LOGGER.debug("{} error response was already completed, ignoring.", (Object)this);
        }
        return Mono.empty();
    }

    private void receiveResponse(Either<Throwable, CoreEvent> result) {
        this.result = result;
        this.responsePublisher.ifComputed(rp -> {
            rp.result = result;
        });
        for (BiConsumer<CoreEvent, Throwable> onBeforeResponseConsumer : this.onBeforeResponseConsumerList) {
            this.signalConsumerSilently(onBeforeResponseConsumer);
        }
        this.onBeforeResponseConsumerList.clear();
        for (BiConsumer<CoreEvent, Throwable> onResponseConsumer : this.onResponseConsumerList) {
            this.signalConsumerSilently(onResponseConsumer);
        }
        this.onResponseConsumerList.clear();
        this.stateCtx.compareAndSet(1, 2);
        this.tryComplete();
    }

    protected void tryComplete() {
        if (this.stateCtx.get() == 2 && this.areAllChildrenComplete()) {
            BaseEventContext context;
            if (!this.stateCtx.compareAndSet(2, 3)) {
                return;
            }
            if (this.debugLogEnabled) {
                LOGGER.debug("{} completed.", (Object)this);
            }
            for (BiConsumer<CoreEvent, Throwable> consumer : this.onCompletionConsumerList) {
                this.signalConsumerSilently(consumer);
            }
            this.onCompletionConsumerList.clear();
            Optional parentContext = this.getParentContext();
            if (parentContext.isPresent() && (context = (BaseEventContext)parentContext.get()) instanceof AbstractEventContext) {
                AbstractEventContext aec = (AbstractEventContext)context;
                aec.tryComplete();
            }
            this.tryTerminate();
        }
    }

    private boolean areAllChildrenComplete() {
        if (this.childrenComplete) {
            return true;
        }
        this.getChildContextsReadLock().lock();
        try {
            this.childrenComplete = this.childrenComplete || this.childContexts.stream().allMatch(BaseEventContext::isComplete);
        }
        finally {
            this.getChildContextsReadLock().unlock();
        }
        return this.childrenComplete;
    }

    protected void tryTerminate() {
        if ((this.externalCompletion == null || this.externalCompletion.isDone()) && this.stateCtx.compareAndSet(3, 4)) {
            if (this.debugLogEnabled) {
                LOGGER.debug("{} terminated.", (Object)this);
            }
            for (BiConsumer<CoreEvent, Throwable> consumer : this.onTerminatedConsumerList) {
                this.signalConsumerSilently(consumer);
            }
            this.onTerminatedConsumerList.clear();
            this.getChildContextsWriteLock().lock();
            try {
                this.childContexts.clear();
            }
            finally {
                this.getChildContextsWriteLock().unlock();
            }
            this.getParentContext().ifPresent(context -> {
                AbstractEventContext parent = (AbstractEventContext)context;
                parent.getChildContextsWriteLock().lock();
                try {
                    parent.childContexts.remove(this);
                }
                finally {
                    parent.getChildContextsWriteLock().unlock();
                }
            });
            this.result = null;
            this.responsePublisher = null;
        }
    }

    private void signalConsumerSilently(BiConsumer<CoreEvent, Throwable> consumer) {
        try {
            consumer.accept((CoreEvent)this.result.getRight(), (Throwable)this.result.getLeft());
        }
        catch (Throwable t) {
            LOGGER.error(String.format("The event consumer %s, of EventContext %s failed with exception:", consumer, this), t);
        }
    }

    @Override
    public BaseEventContext getRootContext() {
        return this.getParentContext().map(BaseEventContext::getRootContext).orElse(this);
    }

    protected FlowExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    private boolean isResponseDone() {
        return this.stateCtx.get() >= 1;
    }

    @Override
    public boolean isComplete() {
        return this.stateCtx.get() >= 3;
    }

    @Override
    public boolean isTerminated() {
        return this.stateCtx.get() == 4;
    }

    @Override
    public synchronized void onTerminated(BiConsumer<CoreEvent, Throwable> consumer) {
        if (this.stateCtx.get() >= 4) {
            this.signalConsumerSilently(consumer);
        } else {
            this.onTerminatedConsumerList.add(Objects.requireNonNull(consumer));
        }
    }

    @Override
    public synchronized void onComplete(BiConsumer<CoreEvent, Throwable> consumer) {
        if (this.stateCtx.get() >= 3) {
            this.signalConsumerSilently(consumer);
        } else {
            this.onCompletionConsumerList.add(Objects.requireNonNull(consumer));
        }
    }

    @Override
    public synchronized void onBeforeResponse(BiConsumer<CoreEvent, Throwable> consumer) {
        if (this.stateCtx.get() >= 1) {
            this.signalConsumerSilently(consumer);
        } else {
            this.onBeforeResponseConsumerList.add(Objects.requireNonNull(consumer));
        }
    }

    @Override
    public synchronized void onResponse(BiConsumer<CoreEvent, Throwable> consumer) {
        if (this.stateCtx.get() >= 1) {
            this.signalConsumerSilently(consumer);
        } else {
            this.onResponseConsumerList.add(Objects.requireNonNull(consumer));
        }
    }

    @Override
    public synchronized Publisher<CoreEvent> getResponsePublisher() {
        if (this.isTerminated()) {
            throw new IllegalStateException("getResponsePublisher() cannot be called after eventContext termination.");
        }
        return Mono.create((Consumer)((Consumer)this.responsePublisher.get()));
    }

    public void forEachChild(Consumer<BaseEventContext> childConsumer) {
        this.getChildContextsReadLock().lock();
        try {
            this.childContexts.stream().filter(context -> !context.isTerminated()).forEach(context -> {
                childConsumer.accept((BaseEventContext)context);
                if (context instanceof AbstractEventContext) {
                    AbstractEventContext aec = (AbstractEventContext)context;
                    aec.forEachChild(childConsumer);
                }
            });
        }
        finally {
            this.getChildContextsReadLock().unlock();
        }
    }

    @Override
    public int getDepthLevel() {
        return this.depthLevel;
    }

    public Lock getChildContextsReadLock() {
        return this.childContextsReadWriteLock.readLock();
    }

    public Lock getChildContextsWriteLock() {
        return this.childContextsReadWriteLock.writeLock();
    }

    protected abstract String basicToString();

    protected final String detailedToString(int level, BaseEventContext highlight) {
        return (this == highlight ? "=> " : "") + this.basicToString() + System.lineSeparator() + this.childContexts.stream().map(ctx -> StringUtils.leftPad((String)"", (int)((1 + level) * 4)) + ((AbstractEventContext)ctx).detailedToString(1 + level, highlight)).collect(Collectors.joining(System.lineSeparator()));
    }

    protected int getState() {
        return this.stateCtx.get();
    }

    @Override
    public String nextChildId() {
        return this.getId() != null ? this.getId() + "_" + this.childIdProvider.getAndIncrement() : "" + this.childIdProvider.getAndIncrement();
    }

    private final class ResponsePublisher
    implements Consumer<MonoSink<CoreEvent>> {
        private volatile Either<Throwable, CoreEvent> result;

        private ResponsePublisher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(MonoSink<CoreEvent> sink) {
            if (AbstractEventContext.this.isResponseDone()) {
                this.signalPublisherSink(sink);
            } else {
                AbstractEventContext abstractEventContext = AbstractEventContext.this;
                synchronized (abstractEventContext) {
                    if (AbstractEventContext.this.isResponseDone()) {
                        this.signalPublisherSink(sink);
                    } else {
                        AbstractEventContext.this.onResponse((event, throwable) -> {
                            if (throwable != null) {
                                sink.error(throwable);
                            } else {
                                sink.success(event);
                            }
                        });
                    }
                }
            }
        }

        private void signalPublisherSink(MonoSink<CoreEvent> sink) {
            if (this.result.isLeft()) {
                sink.error((Throwable)this.result.getLeft());
            } else {
                sink.success((Object)((CoreEvent)this.result.getRight()));
            }
        }
    }
}

