/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.context;

import org.togglz.core.manager.FeatureManager;
import org.togglz.core.spi.FeatureManagerProvider;

public class ThreadLocalFeatureManagerProvider
implements FeatureManagerProvider {
    private static final ThreadLocal<FeatureManager> threadLocal = new ThreadLocal();

    public static void bind(FeatureManager featureManager) {
        if (featureManager != null && threadLocal.get() != null) {
            throw new IllegalStateException("bind() called for a thread that already has a FeatureManager associated with it. It's likely that the FeatureManager is not correctly removed from the thread before it is put back into the thread pool.");
        }
        threadLocal.set(featureManager);
    }

    public static void release() {
        threadLocal.set(null);
    }

    @Override
    public int priority() {
        return 50;
    }

    @Override
    public FeatureManager getFeatureManager() {
        return threadLocal.get();
    }
}

