/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl;

import java.util.Optional;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.profiling.tracing.event.span.condition.NotNullSpanAssertion;
import org.mule.runtime.core.internal.profiling.tracing.event.span.condition.SpanNameAssertion;
import org.mule.runtime.tracer.api.EventTracer;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.api.span.validation.Assertion;

public class CoreEventComponentTracer
implements ComponentTracer<CoreEvent> {
    private final InitialSpanInfo initialSpanInfo;
    private final EventTracer<CoreEvent> coreEventTracer;
    private final Assertion parentComponentSpanAssertion;
    private final Assertion componentSpanAssertion;

    public CoreEventComponentTracer(InitialSpanInfo initialSpanInfo, EventTracer<CoreEvent> coreEventTracer) {
        this.initialSpanInfo = initialSpanInfo;
        this.coreEventTracer = coreEventTracer;
        this.parentComponentSpanAssertion = NotNullSpanAssertion.getNotNullSpanTracingCondition();
        this.componentSpanAssertion = new SpanNameAssertion(initialSpanInfo.getName());
    }

    public CoreEventComponentTracer(InitialSpanInfo initialSpanInfo, EventTracer<CoreEvent> coreEventTracer, ComponentTracer<?> parentComponentTracer) {
        this.initialSpanInfo = initialSpanInfo;
        this.coreEventTracer = coreEventTracer;
        this.componentSpanAssertion = new SpanNameAssertion(initialSpanInfo.getName());
        this.parentComponentSpanAssertion = parentComponentTracer.getComponentSpanAssertion();
    }

    public Optional<Span> startSpan(CoreEvent coreEvent) {
        return this.coreEventTracer.startSpan((Event)coreEvent, this.initialSpanInfo, this.parentComponentSpanAssertion);
    }

    public void endCurrentSpan(CoreEvent event) {
        this.coreEventTracer.endCurrentSpan((Event)event, this.componentSpanAssertion);
    }

    public void addCurrentSpanAttribute(CoreEvent event, String key, String value) {
        this.coreEventTracer.addCurrentSpanAttribute((Event)event, key, value);
    }

    public Assertion getComponentSpanAssertion() {
        return this.componentSpanAssertion;
    }
}

