/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.reader;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import org.mule.weave.v2.core.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.StreamSourceBufferedCharSequence$;
import org.mule.weave.v2.module.reader.BufferResult;
import org.mule.weave.v2.module.reader.CharsetHelper$;
import org.mule.weave.v2.module.reader.SourceReader;
import org.mule.weave.v2.module.reader.UTF8BufferedCharSequenceReader$;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0012%\u0001EB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\")\u0001\u000b\u0001C\u0001#\"AQ\u000b\u0001EC\u0002\u0013\u0005a\u000bC\u0004[\u0001\t\u0007I\u0011B.\t\r\u0001\u0004\u0001\u0015!\u0003]\u0011\u001d\t\u0007A1A\u0005\nmCaA\u0019\u0001!\u0002\u0013a\u0006bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007]\u0002\u0001\u000b\u0011B3\t\u000f=\u0004!\u0019!C\u0005I\"1\u0001\u000f\u0001Q\u0001\n\u0015Dq!\u001d\u0001A\u0002\u0013\u0005!\u000fC\u0004w\u0001\u0001\u0007I\u0011A<\t\ru\u0004\u0001\u0015)\u0003t\u0011\u0015Y\u0005\u0001\"\u0011\u007f\u0011\u001d\t)\u0001\u0001C!\u0003\u000fAq!!\n\u0001\t\u0003\n9\u0003C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005M\u0002\u0001\"\u0011\u00026!9\u0011q\u0007\u0001\u0005B\u0005U\u0002bBA\u001d\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007Bq!a\u0013\u0001\t\u0003\n9\u0003C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003G\u0003A\u0011BAS\u0011\u001d\t9\f\u0001C\u0005\u0003sCq!a4\u0001\t\u0003\n\t\u000eC\u0004\u0002X\u0002!\t%!\r\t\u000f\u0005e\u0007\u0001\"\u0011\u0002\\\n1R\u000b\u0016$9'R\u0014X-Y7T_V\u00148-\u001a*fC\u0012,'O\u0003\u0002&M\u00051!/Z1eKJT!a\n\u0015\u0002\r5|G-\u001e7f\u0015\tI#&\u0001\u0002we)\u00111\u0006L\u0001\u0006o\u0016\fg/\u001a\u0006\u0003[9\nA!\\;mK*\tq&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001ei\u0002\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\t1\fgn\u001a\u0006\u0002o\u0005!!.\u0019<b\u0013\tIDG\u0001\u0004PE*,7\r\u001e\t\u0003wqj\u0011\u0001J\u0005\u0003{\u0011\u0012AbU8ve\u000e,'+Z1eKJ\fab]3fW\u0006\u0014G.Z*ue\u0016\fW\u000e\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u0006\u0011\u0011n\u001c\u0006\u0003\t\"\nAaY8sK&\u0011a)\u0011\u0002\u000f'\u0016,7.\u00192mKN#(/Z1n\u0003-)8/\u001a3DQ\u0006\u00148/\u001a;\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015aB2iCJ\u001cX\r\u001e\u0006\u0003\u001bZ\n1A\\5p\u0013\ty%JA\u0004DQ\u0006\u00148/\u001a;\u0002\rqJg.\u001b;?)\r\u00116\u000b\u0016\t\u0003w\u0001AQAP\u0002A\u0002}BQaR\u0002A\u0002!\u000bq\u0001Z3d_\u0012,'/F\u0001X!\tI\u0005,\u0003\u0002Z\u0015\nq1\t[1sg\u0016$H)Z2pI\u0016\u0014\u0018AC2iCJ\u0014UO\u001a4feV\tA\f\u0005\u0002^=6\tA*\u0003\u0002`\u0019\nQ1\t[1s\u0005V4g-\u001a:\u0002\u0017\rD\u0017M\u001d\"vM\u001a,'\u000fI\u0001\u0012I\u00164\u0017-\u001e7u\u0007\"\f'OQ;gM\u0016\u0014\u0018A\u00053fM\u0006,H\u000e^\"iCJ\u0014UO\u001a4fe\u0002\n\u0001\u0003Z3gCVdGOQ=uK\u0006\u0013(/Y=\u0016\u0003\u0015\u00042AZ5l\u001b\u00059'\"\u00015\u0002\u000bM\u001c\u0017\r\\1\n\u0005)<'!B!se\u0006L\bC\u00014m\u0013\tiwM\u0001\u0003CsR,\u0017!\u00053fM\u0006,H\u000e\u001e\"zi\u0016\f%O]1zA\u0005)B-\u001a4bk2$8\t[1sg\nKH/Z!se\u0006L\u0018A\u00063fM\u0006,H\u000e^\"iCJ\u001c()\u001f;f\u0003J\u0014\u0018-\u001f\u0011\u0002\u0015}\u0013X-\u00193CsR,7/F\u0001t!\t1G/\u0003\u0002vO\n\u0019\u0011J\u001c;\u0002\u001d}\u0013X-\u00193CsR,7o\u0018\u0013fcR\u0011\u0001p\u001f\t\u0003MfL!A_4\u0003\tUs\u0017\u000e\u001e\u0005\by:\t\t\u00111\u0001t\u0003\rAH%M\u0001\f?J,\u0017\r\u001a\"zi\u0016\u001c\b%F\u0001\u0000!\u00111\u0017\u0011\u0001%\n\u0007\u0005\rqM\u0001\u0004PaRLwN\\\u0001\fG>\u0004\u0018PQ=uKN$v\u000eF\u0004y\u0003\u0013\t\u0019\"a\u0006\t\u000f\u0005-\u0011\u00031\u0001\u0002\u000e\u0005i1\u000f^1siB{7/\u001b;j_:\u00042AZA\b\u0013\r\t\tb\u001a\u0002\u0005\u0019>tw\r\u0003\u0004\u0002\u0016E\u0001\ra]\u0001\u0007Y\u0016tw\r\u001e5\t\u000f\u0005e\u0011\u00031\u0001\u0002\u001c\u00051A/\u0019:hKR\u0004B!!\b\u0002\"5\u0011\u0011q\u0004\u0006\u0003\u0005ZJA!a\t\u0002 \taq*\u001e;qkR\u001cFO]3b[\u0006I!/Z1e\u0003N\u001c\u0017.\u001b\u000b\u0003\u0003S\u00012AZA\u0016\u0013\r\tic\u001a\u0002\u0005\u0007\"\f'/A\u0005iC:$G.\u001a\"P\u001bR\t\u00010\u0001\u0005q_NLG/[8o)\t\ti!\u0001\tqe\u00164\u0018n\\;t!>\u001c\u0018\u000e^5p]\u0006qAn\\8l\u0003\",\u0017\rZ!tG&L\u0017\u0001B:fK.$2\u0001_A \u0011\u001d\t\u0019d\u0006a\u0001\u0003\u001b\ta\"\u001b8NK6|'/\u001f*fC\u0012,'\u000f\u0006\u0002\u0002FA\u0019a-a\u0012\n\u0007\u0005%sMA\u0004C_>dW-\u00198\u0002\tI,\u0017\rZ\u0001%G\u0006d7-\u001e7bi\u0016\u0014V-\\1j]&twMQ=uKN$vNU3bI\u001a{'o\u00115beR\u00191/!\u0015\t\r\u0005M#\u00041\u0001l\u0003\u0011\u0011\u0017\u0010^3\u0002#I,\u0017\rZ#oG>$W\rZ*ue&tw\r\u0006\u0004\u0002Z\u0005=\u00141\u000f\t\u0005\u00037\nIG\u0004\u0003\u0002^\u0005\u0015\u0004cAA0O6\u0011\u0011\u0011\r\u0006\u0004\u0003G\u0002\u0014A\u0002\u001fs_>$h(C\u0002\u0002h\u001d\fa\u0001\u0015:fI\u00164\u0017\u0002BA6\u0003[\u0012aa\u0015;sS:<'bAA4O\"9\u0011\u0011O\u000eA\u0002\u00055\u0011\u0001\u00024s_6Dq!!\u0006\u001c\u0001\u0004\ti!A\fsK\u0006$WI\\2pI\u0016$7\t[1s'\u0016\fX/\u001a8dKR1\u0011\u0011PAI\u0003+#B!a\u001f\u0002\u0002B\u00191'! \n\u0007\u0005}DG\u0001\u0007DQ\u0006\u00148+Z9vK:\u001cW\rC\u0004\u0002\u0004r\u0001\u001d!!\"\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\b\u00065UBAAE\u0015\r\tY\tK\u0001\u0006[>$W\r\\\u0005\u0005\u0003\u001f\u000bIIA\tFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqRDq!a%\u001d\u0001\u0004\ti!\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0003+a\u0002\u0019AA\u0007\u0003e\u0011X-\u00193F]\u000e|G-\u001a3DQ\u0006\u00148/\u00168uS2\u001c\u0016N_3\u0015\u0011\u0005e\u00131TAO\u0003?Cq!a%\u001e\u0001\u0004\ti\u0001C\u0004\u0002\u0016u\u0001\r!!\u0004\t\r\u0005\u0005V\u00041\u0001t\u0003-\u0019\u0007.\u0019:t)>\u0014V-\u00193\u0002)I,\u0017\r\u001a\"zi\u0016\u001cXK\u001c;jY:\u001b\u0005.\u0019:t))\t9+!,\u00020\u0006E\u00161\u0017\t\u0006M\u0006%6/Z\u0005\u0004\u0003W;'A\u0002+va2,'\u0007C\u0004\u0002\u0014z\u0001\r!!\u0004\t\u000f\u0005Ua\u00041\u0001\u0002\u000e!1\u0011\u0011\u0015\u0010A\u0002MDa!!.\u001f\u0001\u0004)\u0017A\u00022vM\u001a,'/\u0001\bd_VtGo\u00115beN\u0014V-\u00193\u0015\u0019\u0005m\u0016\u0011YAb\u0003\u000b\f9-a3\u0011\u0007m\ni,C\u0002\u0002@\u0012\u0012ABQ;gM\u0016\u0014(+Z:vYRDq!a% \u0001\u0004\ti\u0001C\u0004\u0002\u0016}\u0001\r!!\u0004\t\r\u0005Uv\u00041\u0001f\u0011\u0019\tIm\ba\u0001g\u0006Y!-\u001e4gKJLe\u000eZ3y\u0011\u0019\tim\ba\u0001g\u0006a!-\u001e4gKJdUM\\4uQ\u0006y!/Z1e\u0003N\u001c\u0017.[*ue&tw\r\u0006\u0004\u0002Z\u0005M\u0017Q\u001b\u0005\b\u0003c\u0002\u0003\u0019AA\u0007\u0011\u001d\t)\u0002\ta\u0001\u0003\u001b\tQa\u00197pg\u0016\f1\"[:CsR,')Y:fIV\u0011\u0011Q\t")
public class UTF8StreamSourceReader
implements SourceReader {
    private CharsetDecoder decoder;
    private final SeekableStream seekableStream;
    private final Charset usedCharset;
    private final CharBuffer charBuffer;
    private final CharBuffer defaultCharBuffer;
    private final byte[] defaultByteArray;
    private final byte[] defaultCharsByteArray;
    private int _readBytes;
    private volatile boolean bitmap$0;

    @Override
    public boolean supportsSeek() {
        return SourceReader.supportsSeek$(this);
    }

    @Override
    public boolean requireClose() {
        return SourceReader.requireClose$(this);
    }

    private CharsetDecoder decoder$lzycompute() {
        UTF8StreamSourceReader uTF8StreamSourceReader = this;
        synchronized (uTF8StreamSourceReader) {
            if (!this.bitmap$0) {
                this.decoder = this.usedCharset.newDecoder();
                this.bitmap$0 = true;
            }
        }
        return this.decoder;
    }

    public CharsetDecoder decoder() {
        if (!this.bitmap$0) {
            return this.decoder$lzycompute();
        }
        return this.decoder;
    }

    private CharBuffer charBuffer() {
        return this.charBuffer;
    }

    private CharBuffer defaultCharBuffer() {
        return this.defaultCharBuffer;
    }

    private byte[] defaultByteArray() {
        return this.defaultByteArray;
    }

    private byte[] defaultCharsByteArray() {
        return this.defaultCharsByteArray;
    }

    public int _readBytes() {
        return this._readBytes;
    }

    public void _readBytes_$eq(int x$1) {
        this._readBytes = x$1;
    }

    @Override
    public Option<Charset> charset() {
        return new Some((Object)this.usedCharset);
    }

    @Override
    public void copyBytesTo(long startPosition, int length, OutputStream target) {
        int amountRead;
        this.seekableStream.seek(startPosition);
        for (int totalRead = 0; totalRead < length; totalRead += amountRead) {
            int minLength = Math.min(this.defaultByteArray().length, length - totalRead);
            amountRead = ((InputStream)((Object)this.seekableStream)).read(this.defaultByteArray(), 0, minLength);
            target.write(this.defaultByteArray(), 0, amountRead);
        }
    }

    @Override
    public char readAscii() {
        int read;
        if (this.seekableStream.position() == 0L) {
            this.handleBOM();
        }
        if ((read = ((InputStream)((Object)this.seekableStream)).read()) != -1) {
            this._readBytes_$eq(1);
            return (char)(read & 0xFF);
        }
        this._readBytes_$eq(0);
        return '\uffff';
    }

    public void handleBOM() {
        Option<byte[]> mayBeBom = CharsetHelper$.MODULE$.getBom(this.usedCharset);
        byte[] bom = (byte[])mayBeBom.get();
        byte[] inputBom = new byte[bom.length];
        ((InputStream)((Object)this.seekableStream)).read(inputBom);
        if (inputBom[0] != bom[0] || inputBom[1] != bom[1] || inputBom[2] != bom[2]) {
            this.seekableStream.seek(0L);
            return;
        }
    }

    @Override
    public long position() {
        long position = this.seekableStream.position();
        if (position == 0L) {
            this.handleBOM();
            return this.seekableStream.position();
        }
        return position;
    }

    @Override
    public long previousPosition() {
        return this.position() - (long)this._readBytes();
    }

    @Override
    public char lookAheadAscii() {
        char c;
        long startPosition = this.position();
        try {
            c = this.readAscii();
        }
        finally {
            this.seek(startPosition);
        }
        return c;
    }

    @Override
    public void seek(long position) {
        this.seekableStream.seek(position);
    }

    @Override
    public boolean inMemoryReader() {
        return this.seekableStream.inMemoryStream();
    }

    @Override
    public char read() {
        char c;
        int remainingBytes;
        if (this.charBuffer().position() == this.charBuffer().length()) {
            return this.charBuffer().get();
        }
        byte _read = (byte)((InputStream)((Object)this.seekableStream)).read();
        if (_read == -1) {
            this._readBytes_$eq(0);
            return '\uffff';
        }
        int n = remainingBytes = this.calculateRemainingBytesToReadForChar(_read);
        switch (n) {
            case -1: {
                c = '\ufffd';
                break;
            }
            case 0: {
                this._readBytes_$eq(1);
                c = (char)_read;
                break;
            }
            default: {
                this._readBytes_$eq(remainingBytes + 1);
                c = this.decode$1(_read, remainingBytes);
                break;
            }
        }
        char charRead = c;
        return charRead;
    }

    private int calculateRemainingBytesToReadForChar(byte by) {
        if (by >= 0) {
            return 0;
        }
        if ((by & 0xE0) == 192) {
            return 1;
        }
        if ((by & 0xF0) == 224) {
            return 2;
        }
        if ((by & 0xF8) == 240) {
            return 3;
        }
        return -1;
    }

    @Override
    public String readEncodedString(long from, long length) {
        byte[] bytes = (long)this.defaultByteArray().length > length ? this.defaultByteArray() : new byte[(int)length];
        this.seek(from);
        int amount = ((InputStream)((Object)this.seekableStream)).read(bytes, 0, (int)length);
        if (amount == -1) {
            throw new IllegalArgumentException(new StringBuilder(85).append("The end of the stream has been reached while reading encoded string from: ").append(from).append(", length: ").append(length).append(".").toString());
        }
        CharBuffer charBuffer = (long)this.defaultCharBuffer().capacity() < length ? CharBuffer.allocate((int)length) : this.defaultCharBuffer();
        charBuffer.clear();
        this.decoder().decode(ByteBuffer.wrap(bytes, 0, amount), charBuffer, true);
        int decodedLength = charBuffer.position();
        return new String(charBuffer.array(), 0, decodedLength);
    }

    @Override
    public CharSequence readEncodedCharSequence(long offset, long length, EvaluationContext ctx) {
        if (ctx.serviceManager().settingsService().bufferedCharSequence().enabled()) {
            if (length <= (long)ctx.serviceManager().settingsService().memory().maxMemoryAllocation()) {
                return this.readEncodedString(offset, length);
            }
            return StreamSourceBufferedCharSequence$.MODULE$.apply(UTF8BufferedCharSequenceReader$.MODULE$.apply(this, offset, length));
        }
        return this.readEncodedString(offset, length);
    }

    public String readEncodedCharsUntilSize(long offset, long length, int charsToRead) {
        byte[] buffer = (long)this.defaultCharsByteArray().length > length ? this.defaultCharsByteArray() : new byte[charsToRead * 4];
        Tuple2<Object, byte[]> tuple2 = this.readBytesUntilNChars(offset, length, charsToRead, buffer);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int bytesLength = tuple2._1$mcI$sp();
        byte[] bytesRead = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bytesLength), (Object)bytesRead);
        int bytesLength2 = tuple22._1$mcI$sp();
        byte[] bytesRead2 = (byte[])tuple22._2();
        CharBuffer charBuffer = this.defaultCharBuffer().capacity() < charsToRead ? CharBuffer.allocate(charsToRead) : this.defaultCharBuffer();
        charBuffer.clear();
        this.decoder().decode(ByteBuffer.wrap(bytesRead2, 0, bytesLength2), charBuffer, true);
        int decodedLength = charBuffer.position();
        return new String(charBuffer.array(), 0, decodedLength);
    }

    private Tuple2<Object, byte[]> readBytesUntilNChars(long offset, long length, int charsToRead, byte[] buffer) {
        this.seek(offset);
        if (length <= (long)charsToRead) {
            int lengthToRead = (int)length;
            int amount = ((InputStream)((Object)this.seekableStream)).read(buffer, 0, lengthToRead);
            if (amount == -1) {
                throw new IllegalArgumentException(new StringBuilder(86).append("The end of the stream has been reached while reading encoded chars offset: ").append(offset).append(", length: ").append(length).append(".").toString());
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)lengthToRead), (Object)buffer);
        }
        return this.loop$1(length, 0, charsToRead, buffer, 0, 0, charsToRead, offset, length);
    }

    private BufferResult countCharsRead(long offset, long length, byte[] buffer, int bufferIndex, int bufferLength) {
        int charsCount = 0;
        int remainingBytes = 0;
        int index = bufferIndex;
        while (index < bufferLength) {
            byte by = buffer[index];
            int remaining = this.calculateRemainingBytesToReadForChar(by);
            if (remaining == -1) {
                throw new IllegalArgumentException(new StringBuilder(77).append("An error char has been reached while reading encoded chars offset: ").append(offset).append(", length: ").append(length).toString());
            }
            remainingBytes += remaining;
            index += remaining + 1;
            ++charsCount;
        }
        return new BufferResult(index, remainingBytes, charsCount);
    }

    @Override
    public String readAsciiString(long from, long length) {
        byte[] bytes = (long)this.defaultByteArray().length > length ? this.defaultByteArray() : new byte[(int)length];
        this.seek(from);
        int amount = ((InputStream)((Object)this.seekableStream)).read(bytes, 0, (int)length);
        if (amount == -1) {
            throw new IllegalArgumentException(new StringBuilder(83).append("The end of the stream has been reached while reading ascii string from: ").append(from).append(", length: ").append(length).append(".").toString());
        }
        return new String(bytes, 0, amount, StandardCharsets.US_ASCII);
    }

    @Override
    public void close() {
        this.seekableStream.close();
    }

    @Override
    public boolean isByteBased() {
        return true;
    }

    private final char decode$1(byte by, int remainingBytes) {
        this.charBuffer().clear();
        byte[] bytes = new byte[remainingBytes + 1];
        bytes[0] = by;
        int amountThatWasRead = ((InputStream)((Object)this.seekableStream)).read(bytes, 1, remainingBytes);
        CoderResult result = this.decoder().decode(ByteBuffer.wrap(bytes), this.charBuffer(), true);
        if (!result.isError()) {
            char c;
            try {
                this.charBuffer().flip();
                c = this.charBuffer().get();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                this.seek(this.position() - (long)amountThatWasRead);
                c = this.read();
            }
            return c;
        }
        this.seek(this.position() - (long)amountThatWasRead);
        return this.read();
    }

    private final Tuple2 loop$1(long remaining, int charsRead, int bytesToRead, byte[] buffer, int bufferOffset, int bufferIndex, int charsToRead$1, long offset$1, long length$1) {
        while (true) {
            if (charsRead == charsToRead$1 || remaining == 0L) {
                int bytes;
                int amount;
                if (bytesToRead != 0 && (amount = ((InputStream)((Object)this.seekableStream)).read(buffer, bufferOffset, bytes = (int)Math.min(remaining, (long)bytesToRead))) == -1) {
                    throw new IllegalArgumentException(new StringBuilder(86).append("The end of the stream has been reached while reading encoded chars offset: ").append(offset$1).append(", length: ").append(length$1).append(".").toString());
                }
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)(bufferOffset + bytesToRead)), (Object)buffer);
            }
            int bytes = (int)Math.min(remaining, (long)bytesToRead);
            int amount = ((InputStream)((Object)this.seekableStream)).read(buffer, bufferOffset, bytes);
            if (amount == -1) {
                throw new IllegalArgumentException(new StringBuilder(86).append("The end of the stream has been reached while reading encoded chars offset: ").append(offset$1).append(", length: ").append(length$1).append(".").toString());
            }
            int bufferLength = bufferOffset + bytes;
            BufferResult result = this.countCharsRead(offset$1, length$1, buffer, bufferIndex, bufferLength);
            bufferIndex = result.bufferIndex();
            bufferOffset = bufferLength;
            bytesToRead = result.remainingBytes();
            charsRead += result.charsCount();
            remaining -= (long)bytes;
        }
    }

    public UTF8StreamSourceReader(SeekableStream seekableStream, Charset usedCharset) {
        this.seekableStream = seekableStream;
        this.usedCharset = usedCharset;
        SourceReader.$init$(this);
        this.charBuffer = CharBuffer.allocate(2);
        this.defaultCharBuffer = CharBuffer.allocate(8192);
        this.defaultByteArray = new byte[8192];
        this.defaultCharsByteArray = new byte[16384];
        this._readBytes = 0;
    }
}

