/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.message.sse;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mule.service.http.common.message.sse.ServerSentEventImpl;
import org.mule.service.http.test.netty.tck.IsOptionalOf;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Server Sent Events (SSE)")
@Story(value="SSE Protocol")
public class ServerSentEventImplTestCase
extends AbstractMuleTestCase {
    @Test
    public void hashAndEquals() {
        EqualsVerifier.simple().forClass(ServerSentEventImpl.class).verify();
    }

    @Test
    public void requiredParametersCannotBeNull() {
        NullPointerException dataCantBeNull = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> new ServerSentEventImpl("name", null, null, null));
        MatcherAssert.assertThat((Object)dataCantBeNull, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.is((Object)"eventData cannot be null")));
        NullPointerException nameCantBeNull = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> new ServerSentEventImpl(null, "data", null, null));
        MatcherAssert.assertThat((Object)nameCantBeNull, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.is((Object)"eventName cannot be null")));
    }

    @Test
    public void toStringShowsAllFields() {
        ServerSentEventImpl eventFull = new ServerSentEventImpl("name", "data1\ndata2", "id", Long.valueOf(500L));
        MatcherAssert.assertThat((Object)eventFull, (Matcher)Matchers.hasToString((String)"ServerSentEvent [name=name, data=data1\ndata2, id=id, retryDelay=500]"));
    }

    @Test
    public void toStringShowsAbsentFieldsAsNulls() {
        ServerSentEventImpl eventFull = new ServerSentEventImpl("name", "data1\ndata2", null, null);
        MatcherAssert.assertThat((Object)eventFull, (Matcher)Matchers.hasToString((String)"ServerSentEvent [name=name, data=data1\ndata2, id=null, retryDelay=null]"));
    }

    @Test
    public void getters() {
        ServerSentEventImpl eventFull = new ServerSentEventImpl("name", "data1\ndata2", "id", Long.valueOf(500L));
        MatcherAssert.assertThat((Object)eventFull.getName(), (Matcher)Matchers.is((Object)"name"));
        MatcherAssert.assertThat((Object)eventFull.getData(), (Matcher)Matchers.is((Object)"data1\ndata2"));
        MatcherAssert.assertThat((Object)eventFull.getId(), (Matcher)Matchers.is(IsOptionalOf.isOptionalOf("id")));
        MatcherAssert.assertThat((Object)eventFull.getRetryDelay(), (Matcher)Matchers.is(IsOptionalOf.isOptionalOf(500L)));
    }
}

