/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.store;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;

public abstract class ObjectStoreToMapAdapter<T extends Serializable>
implements Map<String, T> {
    protected abstract ObjectStore<T> getObjectStore();

    @Override
    public int size() {
        try {
            return this.getObjectStore().allKeys().size();
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.getObjectStore().allKeys().isEmpty();
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.getObjectStore().contains((String)key);
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Map adapter for object store does not support contains value");
    }

    @Override
    public T get(Object key) {
        try {
            if (!this.getObjectStore().contains((String)key)) {
                return null;
            }
            return this.getObjectStore().retrieve((String)key);
        }
        catch (ObjectDoesNotExistException e) {
            return null;
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public T put(String key, T value) {
        T previousValue = null;
        try {
            if (this.getObjectStore().contains(key)) {
                previousValue = this.getObjectStore().retrieve(key);
                this.getObjectStore().remove(key);
            }
            if (value != null) {
                this.getObjectStore().store(key, value);
            }
            return previousValue;
        }
        catch (ObjectAlreadyExistsException | ObjectDoesNotExistException e) {
            return null;
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public T remove(Object key) {
        try {
            if (this.getObjectStore().contains((String)key)) {
                return this.getObjectStore().remove((String)key);
            }
        }
        catch (ObjectDoesNotExistException e) {
            return null;
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> mapToAdd) {
        for (String string : mapToAdd.keySet()) {
            this.put(string, (T)((Serializable)mapToAdd.get(string)));
        }
    }

    @Override
    public void clear() {
        try {
            this.getObjectStore().clear();
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public Set<String> keySet() {
        try {
            List<String> allKeys = this.getObjectStore().allKeys();
            return new HashSet<String>(allKeys);
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public Collection<T> values() {
        throw new UnsupportedOperationException("ObjectStoreToMapAdapter does not support values() method");
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        throw new UnsupportedOperationException("ObjectStoreToMapAdapter does not support entrySet() method");
    }
}

