/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.testing.assertj.AssertUtil;
import io.opentelemetry.sdk.testing.assertj.LongPointAssert;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public final class LongSumAssert
extends AbstractAssert<LongSumAssert, SumData<LongPointData>> {
    LongSumAssert(SumData<LongPointData> actual) {
        super(actual, LongSumAssert.class);
    }

    public LongSumAssert isMonotonic() {
        this.isNotNull();
        if (!((SumData)this.actual).isMonotonic()) {
            this.failWithActualExpectedAndMessage(this.actual, "monotonic: true", "Expected Sum to be monotonic", new Object[]{true, ((SumData)this.actual).isMonotonic()});
        }
        return (LongSumAssert)this.myself;
    }

    public LongSumAssert isNotMonotonic() {
        this.isNotNull();
        if (((SumData)this.actual).isMonotonic()) {
            this.failWithActualExpectedAndMessage(this.actual, "monotonic: fail", "Expected Sum to be non-monotonic, found: %s", new Object[]{((SumData)this.actual).isMonotonic()});
        }
        return (LongSumAssert)this.myself;
    }

    public LongSumAssert isCumulative() {
        this.isNotNull();
        if (((SumData)this.actual).getAggregationTemporality() != AggregationTemporality.CUMULATIVE) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: CUMULATIVE", "Expected Sum to have cumulative aggregation but found <%s>", new Object[]{((SumData)this.actual).getAggregationTemporality()});
        }
        return (LongSumAssert)this.myself;
    }

    public LongSumAssert isDelta() {
        this.isNotNull();
        if (((SumData)this.actual).getAggregationTemporality() != AggregationTemporality.DELTA) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: DELTA", "Expected Sum to have delta aggregation but found <%s>", new Object[]{((SumData)this.actual).getAggregationTemporality()});
        }
        return (LongSumAssert)this.myself;
    }

    @SafeVarargs
    public final LongSumAssert hasPointsSatisfying(Consumer<LongPointAssert> ... assertions) {
        return this.hasPointsSatisfying(Arrays.asList(assertions));
    }

    public LongSumAssert hasPointsSatisfying(Iterable<? extends Consumer<LongPointAssert>> assertions) {
        Assertions.assertThat((Collection)((SumData)this.actual).getPoints()).satisfiesExactlyInAnyOrder((Consumer[])AssertUtil.toConsumers(assertions, LongPointAssert::new));
        return this;
    }
}

