/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.description;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.module.extension.internal.capability.xml.description.AbstractDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.description.ParameterDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.schema.MethodDocumentation;

final class OperationDescriptionDocumenter
extends AbstractDescriptionDocumenter {
    private final ParameterDescriptionDocumenter parameterDeclarer;

    OperationDescriptionDocumenter(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        this.parameterDeclarer = new ParameterDescriptionDocumenter(processingEnv);
    }

    void document(TypeElement element, WithOperationsDeclaration<?> ... containerDeclarations) {
        Map<String, Element> methods = this.getAllOperations(this.processingEnv, element);
        try {
            for (WithOperationsDeclaration<?> declaration : containerDeclarations) {
                this.documentOperations(declaration, methods);
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Exception found while trying to obtain descriptions"), (Throwable)e);
        }
    }

    private void documentOperations(WithOperationsDeclaration<?> declaration, Map<String, Element> methods) {
        for (OperationDeclaration operation : declaration.getOperations()) {
            Element method = methods.get(operation.getName());
            if (method == null) continue;
            MethodDocumentation documentation = processor.getMethodDocumentation(this.processingEnv, method);
            operation.setDescription(documentation.getSummary());
            this.parameterDeclarer.document((ParameterizedDeclaration<?>)operation, method, documentation);
        }
    }

    private Map<String, Element> getAllOperations(ProcessingEnvironment processingEnv, Element element) {
        LinkedHashMap<String, Element> elements = new LinkedHashMap<String, Element>();
        Consumer<TypeElement> consumer = c -> elements.putAll(this.getApiMethods(processingEnv, this.getOperationClasses(processingEnv, (Element)c)));
        processor.getArrayClassAnnotationValue(element, Configurations.class, "value", processingEnv).forEach(consumer);
        processor.getArrayClassAnnotationValue(element, org.mule.sdk.api.annotation.Configurations.class, "value", processingEnv).forEach(consumer);
        elements.putAll(this.getApiMethods(processingEnv, this.getOperationClasses(processingEnv, element)));
        return elements;
    }

    private List<TypeElement> getOperationClasses(ProcessingEnvironment processingEnv, Element element) {
        List<TypeElement> types = processor.getArrayClassAnnotationValue(element, Operations.class, "value", processingEnv);
        types.addAll(processor.getArrayClassAnnotationValue(element, org.mule.sdk.api.annotation.Operations.class, "value", processingEnv));
        return types;
    }
}

