/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.troubleshooting.internal.operations;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.manifest.api.MuleManifest;
import org.mule.runtime.module.troubleshooting.api.ArgumentDefinition;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperation;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationCallback;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultTroubleshootingOperationDefinition;

public class BasicInfoOperation
implements TroubleshootingOperation {
    public static final String BASIC_INFO_OPERATION_NAME = "basicInfo";
    public static final String BASIC_INFO_OPERATION_DESCRIPTION = "Collects basic environment and metadata information for the current Mule Runtime";
    private static final TroubleshootingOperationDefinition definition = BasicInfoOperation.createOperationDefinition();
    private static final Set<String> SENSITIVE_PROPERTIES = Set.of("anypoint.platform.client_secret", "anypoint.platform.proxy_username", "anypoint.platform.proxy_password", "anypoint.platform.encryption_key", "mule.session.sign.cloudHub.secretKey");

    @Override
    public TroubleshootingOperationDefinition getDefinition() {
        return definition;
    }

    @Override
    public TroubleshootingOperationCallback getCallback() {
        return (arguments, writer) -> {
            MuleManifest muleManifest = MuleManifest.getMuleManifest();
            writer.write("Mule:" + System.lineSeparator());
            writer.write("  %s %s (build %s)".formatted(muleManifest.getProductName(), muleManifest.getProductVersion(), muleManifest.getBuildNumber()) + System.lineSeparator());
            writer.write("  mule_home: %s".formatted(MuleFoldersUtil.getMuleHomeFolder().getAbsolutePath()) + System.lineSeparator());
            writer.write("  mule_base: %s".formatted(MuleFoldersUtil.getMuleBaseFolder().getAbsolutePath()) + System.lineSeparator());
            writer.write(System.lineSeparator());
            writer.write("System Properties:" + System.lineSeparator());
            Map allProperties = System.getProperties().stringPropertyNames().stream().filter(property -> property.startsWith("mule.") || property.startsWith("com.mulesoft.dw") || property.startsWith("anypoint.platform")).filter(property -> !SENSITIVE_PROPERTIES.contains(property)).collect(Collectors.toMap(UnaryOperator.identity(), System::getProperty, (v1, v2) -> v1, TreeMap::new));
            for (Map.Entry entry : allProperties.entrySet()) {
                writer.write("  %s: %s".formatted(entry.getKey(), entry.getValue()) + System.lineSeparator());
            }
            writer.write(System.lineSeparator());
            writer.write("Java:" + System.lineSeparator());
            writer.write("  Version:   %s".formatted(System.getProperty("java.version")) + System.lineSeparator());
            writer.write("  Vendor:    %s".formatted(System.getProperty("java.vendor")) + System.lineSeparator());
            writer.write("  VM name:   %s".formatted(System.getProperty("java.vm.name")) + System.lineSeparator());
            writer.write("  JAVA_HOME: %s".formatted(System.getProperty("java.home")) + System.lineSeparator());
            writer.write(System.lineSeparator());
            writer.write("OS:" + System.lineSeparator());
            writer.write("  Name:      %s".formatted(System.getProperty("os.name")) + System.lineSeparator());
            writer.write("  Version:   %s".formatted(System.getProperty("os.version")) + System.lineSeparator());
            writer.write("  Arch:      %s".formatted(System.getProperty("os.arch")) + System.lineSeparator());
            writer.write(System.lineSeparator());
            String runningTime = ProcessHandle.current().info().startInstant().map(i -> Duration.between(i, Instant.now())).map(d -> DurationFormatUtils.formatDuration((long)d.toMillis(), (String)"d'd' HH:mm:ss.SSS")).orElse("n/a");
            writer.write("Running time: %s".formatted(runningTime));
            writer.write(System.lineSeparator());
        };
    }

    private static TroubleshootingOperationDefinition createOperationDefinition() {
        return new DefaultTroubleshootingOperationDefinition(BASIC_INFO_OPERATION_NAME, BASIC_INFO_OPERATION_DESCRIPTION, new ArgumentDefinition[0]);
    }
}

