/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.timeout.IdleStateHandler;
import io.qameta.allure.Issue;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.netty.impl.client.ReactorNettyClient;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.DisposableServer;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.server.HttpServer;

public class NettyHttpClientTLSRenegotiateTestCase
extends AbstractMuleTestCase {
    @Rule
    public final SystemProperty allowUnsafeCertChange = new SystemProperty("jdk.tls.allowUnsafeServerCertChange", "true");
    @Rule
    public final SystemProperty allowLegacyHelloMessages = new SystemProperty("jdk.tls.allowLegacyHelloMessages", "true");
    @Rule
    public final SystemProperty rejectClientInitiatedRenegotiation = new SystemProperty("jdk.tls.rejectClientInitiatedRenegotiation", "false");
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    private NettyHttpClient httpClientUsingTLSv12;
    private NettyHttpClient httpClientUsingTLSv13;

    @Before
    public void setUp() throws Exception {
        this.httpClientUsingTLSv12 = NettyHttpClient.builder().withConnectionIdleTimeout(10000).withSslContext(SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(InsecureTrustManagerFactory.INSTANCE).protocols(new String[]{"TLSv1.2"}).build()).withUsingPersistentConnections(true).build();
        this.httpClientUsingTLSv13 = NettyHttpClient.builder().withConnectionIdleTimeout(10000).withSslContext(SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(InsecureTrustManagerFactory.INSTANCE).protocols(new String[]{"TLSv1.3"}).build()).withUsingPersistentConnections(true).build();
        this.httpClientUsingTLSv12.start();
        this.httpClientUsingTLSv13.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Issue(value="W-17849284")
    public void testTLSv1_2RenegotiationShouldBeAttempted() throws Exception {
        DisposableServer server = null;
        try {
            server = ((HttpServer)HttpServer.create().port(this.serverPort.getNumber()).secure(spec -> {
                try {
                    spec.sslContext(this.buildSslContext("TLSv1.2"));
                }
                catch (CertificateException | SSLException e) {
                    throw new RuntimeException(e);
                }
            }).doOnConnection(conn -> conn.addHandlerLast((ChannelHandler)new IdleStateHandler(0, 0, 30)))).route(routes -> routes.get("/test-tls-v1_2", (request, response) -> response.header((CharSequence)"Connection", (CharSequence)"keep-alive").sendString((Publisher)Mono.just((Object)"renegotiation")))).bindNow();
            String serverUrl = String.format("https://localhost:%d/test-tls-v1_2", this.serverPort.getNumber());
            HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(serverUrl).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
            HttpResponse response = (HttpResponse)this.httpClientUsingTLSv12.sendAsync(httpRequest).get();
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"renegotiation"));
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference renegotiationError = new AtomicReference();
            ((HttpClient)this.getHttpClient(this.getReactorNettyClient(this.httpClientUsingTLSv12)).doOnConnected(conn -> {
                try {
                    Channel channel = conn.channel();
                    ChannelPipeline pipeline = channel.pipeline();
                    SslHandler sslHandler = (SslHandler)pipeline.get(SslHandler.class);
                    if (sslHandler != null) {
                        sslHandler.renegotiate();
                    } else {
                        renegotiationError.set(new IllegalStateException("SslHandler not found in pipeline"));
                    }
                }
                catch (Throwable t) {
                    renegotiationError.set(t);
                }
                finally {
                    latch.countDown();
                }
            })).baseUrl(serverUrl).get().response().doOnTerminate(latch::countDown).subscribe(r -> {}, error -> renegotiationError.compareAndSet(null, error));
            latch.await(10L, TimeUnit.SECONDS);
            Throwable renegotiationThrowable = (Throwable)renegotiationError.get();
            if (renegotiationThrowable != null) {
                Throwable cause = renegotiationThrowable.getCause() != null ? renegotiationThrowable.getCause() : renegotiationThrowable;
                MatcherAssert.assertThat((Object)(cause instanceof SSLHandshakeException), (Matcher)Matchers.is((Object)true));
                MatcherAssert.assertThat((Object)(cause.getMessage() != null && cause.getMessage().contains("no_renegotiation") ? 1 : 0), (Matcher)Matchers.is((Object)true));
            }
        }
        finally {
            if (server != null) {
                server.disposeNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Issue(value="W-17849285")
    public void testTLSv1_3RenegotiationShouldNotBeAttempted() throws Exception {
        DisposableServer server = null;
        try {
            server = ((HttpServer)HttpServer.create().port(this.serverPort.getNumber()).secure(spec -> {
                try {
                    spec.sslContext(this.buildSslContext("TLSv1.3"));
                }
                catch (CertificateException | SSLException e) {
                    throw new RuntimeException(e);
                }
            }).doOnConnection(conn -> conn.addHandlerLast((ChannelHandler)new IdleStateHandler(0, 0, 30)))).route(routes -> routes.get("/test-tls-v1_3", (request, response) -> response.header((CharSequence)"Connection", (CharSequence)"keep-alive").sendString((Publisher)Mono.just((Object)"no renegotiation")))).bindNow();
            String serverUrl = String.format("https://localhost:%d/test-tls-v1_3", this.serverPort.getNumber());
            HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(serverUrl).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
            HttpResponse response = (HttpResponse)this.httpClientUsingTLSv13.sendAsync(httpRequest).get();
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.containsString((String)"no renegotiation"));
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference renegotiationFailure = new AtomicReference();
            AtomicReference status = new AtomicReference();
            ((HttpClient)this.getHttpClient(this.getReactorNettyClient(this.httpClientUsingTLSv13)).doOnConnected(conn -> {
                try {
                    Channel channel = conn.channel();
                    ChannelPipeline pipeline = channel.pipeline();
                    SslHandler sslHandler = (SslHandler)pipeline.get(SslHandler.class);
                    SSLEngine sslEngine = sslHandler.engine();
                    sslHandler.renegotiate().addListener(renegotiateFuture -> {
                        try {
                            if (renegotiateFuture.isSuccess()) {
                                status.set(sslEngine.getHandshakeStatus());
                            } else {
                                renegotiationFailure.set(renegotiateFuture.cause());
                            }
                        }
                        catch (Throwable t) {
                            renegotiationFailure.set(t);
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
                catch (Throwable t) {
                    renegotiationFailure.set(t);
                    latch.countDown();
                }
            })).baseUrl(serverUrl).get().response().doOnTerminate(latch::countDown).subscribe();
            boolean completed = latch.await(10L, TimeUnit.SECONDS);
            MatcherAssert.assertThat((Object)completed, (Matcher)Matchers.is((Object)true));
            Throwable renegotiationThrowable = (Throwable)renegotiationFailure.get();
            if (renegotiationThrowable != null) {
                throw new AssertionError("Renegotiation assertion failed", renegotiationThrowable);
            }
            MatcherAssert.assertThat((Object)((Object)((SSLEngineResult.HandshakeStatus)((Object)status.get()))), (Matcher)Matchers.is((Matcher)Matchers.not((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP))));
            MatcherAssert.assertThat((Object)((Object)((SSLEngineResult.HandshakeStatus)((Object)status.get()))), (Matcher)Matchers.is((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)));
        }
        finally {
            if (server != null) {
                server.disposeNow();
            }
        }
    }

    private SslContext buildSslContext(String protocol) throws CertificateException, SSLException {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        return SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).protocols(new String[]{protocol}).build();
    }

    private ReactorNettyClient getReactorNettyClient(NettyHttpClient client) throws Exception {
        Field field = NettyHttpClient.class.getDeclaredField("reactorNettyClient");
        field.setAccessible(true);
        return (ReactorNettyClient)field.get(client);
    }

    private HttpClient getHttpClient(ReactorNettyClient reactorNettyClient) throws Exception {
        Field field = ReactorNettyClient.class.getDeclaredField("httpClient");
        field.setAccessible(true);
        return (HttpClient)field.get(reactorNettyClient);
    }
}

