/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.integration;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.netty.impl.provider.NettyHttpServiceProvider;
import org.mule.service.http.netty.impl.server.util.DefaultRequestMatcherRegistryBuilder;
import org.mule.service.http.netty.impl.service.NettyHttpServiceImplementation;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class NettyImplementationTestCase
extends AbstractMuleTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("dynamicPort");
    private NettyHttpServiceImplementation httpService;

    @Before
    public void setUp() throws MuleException {
        SchedulerService schedulerService = (SchedulerService)Mockito.mock(SchedulerService.class);
        NettyHttpServiceProvider httpServiceProvider = new NettyHttpServiceProvider();
        httpServiceProvider.setSchedulerService(schedulerService);
        this.httpService = (NettyHttpServiceImplementation)httpServiceProvider.getServiceDefinition().getService();
        LifecycleUtils.startIfNeeded((Object)this.httpService);
    }

    @After
    public void tearDown() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.httpService);
    }

    @Test
    public void createClient() {
        HttpClientConfiguration clientConfig = new HttpClientConfiguration.Builder().setName("TheConfig").build();
        HttpClientFactory clientFactory = this.httpService.getClientFactory();
        HttpClient httpClient = clientFactory.create(clientConfig);
        MatcherAssert.assertThat((Object)httpClient, (Matcher)Matchers.instanceOf(NettyHttpClient.class));
    }

    @Test
    public void createServerWithoutInjectedParams() throws ServerCreationException, ServerNotFoundException {
        DefaultMuleConfiguration configuration = new DefaultMuleConfiguration();
        this.testCreateServerWithFactory(this.httpService.getServerFactory((MuleConfiguration)configuration));
    }

    @Test
    public void createServerWithInjectedParams() throws ServerCreationException, ServerNotFoundException {
        this.testCreateServerWithFactory(this.httpService.getServerFactory());
    }

    private void testCreateServerWithFactory(HttpServerFactory serverFactory) throws ServerCreationException, ServerNotFoundException {
        serverFactory.create(new HttpServerConfiguration.Builder().setName("TheConfig").setHost("localhost").setPort(this.dynamicPort.getNumber()).build());
        MatcherAssert.assertThat((Object)serverFactory.lookup("TheConfig").getClass().getSimpleName(), (Matcher)Matchers.is((Object)"NoLifecycleHttpServer"));
    }

    @Test
    public void getRequestMatcher() {
        MatcherAssert.assertThat((Object)this.httpService.getRequestMatcherRegistryBuilder(), (Matcher)Matchers.instanceOf(DefaultRequestMatcherRegistryBuilder.class));
    }
}

