/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.IdentityTokenResolvable;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.naming.JavaBeanReferenceMaker;
import com.mchange.v2.naming.ReferenceIndirector;
import com.mchange.v2.ser.IndirectlySerialized;
import com.mchange.v2.ser.SerializableUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class JndiRefDataSourceBase
extends IdentityTokenResolvable
implements Referenceable,
Serializable {
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected VetoableChangeSupport vcs = new VetoableChangeSupport(this);
    private boolean caching = true;
    private String factoryClassLocation = C3P0Config.initializeStringPropertyVar("factoryClassLocation", C3P0Defaults.factoryClassLocation());
    private volatile String identityToken;
    private Hashtable jndiEnv;
    private Object jndiName;
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;
    static final JavaBeanReferenceMaker referenceMaker = new JavaBeanReferenceMaker();

    protected PropertyChangeSupport getPropertyChangeSupport() {
        return this.pcs;
    }

    protected VetoableChangeSupport getVetoableChangeSupport() {
        return this.vcs;
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean bl) {
        boolean bl2 = this.caching;
        this.caching = bl;
        if (bl2 != bl) {
            this.pcs.firePropertyChange("caching", bl2, bl);
        }
    }

    public String getFactoryClassLocation() {
        return this.factoryClassLocation;
    }

    public void setFactoryClassLocation(String string) {
        String string2 = this.factoryClassLocation;
        this.factoryClassLocation = string;
        if (!this.eqOrBothNull(string2, string)) {
            this.pcs.firePropertyChange("factoryClassLocation", string2, string);
        }
    }

    @Override
    public String getIdentityToken() {
        return this.identityToken;
    }

    @Override
    public void setIdentityToken(String string) {
        String string2 = this.identityToken;
        this.identityToken = string;
        if (!this.eqOrBothNull(string2, string)) {
            this.pcs.firePropertyChange("identityToken", string2, string);
        }
    }

    public Hashtable getJndiEnv() {
        return this.jndiEnv != null ? (Hashtable)this.jndiEnv.clone() : null;
    }

    public void setJndiEnv(Hashtable hashtable) {
        Hashtable hashtable2 = this.jndiEnv;
        Hashtable hashtable3 = this.jndiEnv = hashtable != null ? (Hashtable)hashtable.clone() : null;
        if (!this.eqOrBothNull(hashtable2, hashtable)) {
            this.pcs.firePropertyChange("jndiEnv", hashtable2, hashtable);
        }
    }

    public Object getJndiName() {
        return this.jndiName instanceof Name ? ((Name)this.jndiName).clone() : this.jndiName;
    }

    public void setJndiName(Object object) throws PropertyVetoException {
        Object object2 = this.jndiName;
        if (!this.eqOrBothNull(object2, object)) {
            this.vcs.fireVetoableChange("jndiName", object2, object);
        }
        Object object3 = this.jndiName = object instanceof Name ? ((Name)object).clone() : object;
        if (!this.eqOrBothNull(object2, object)) {
            this.pcs.firePropertyChange("jndiName", object2, object);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vcs.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vcs.removeVetoableChangeListener(vetoableChangeListener);
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        return this.vcs.getVetoableChangeListeners();
    }

    private boolean eqOrBothNull(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeShort(1);
        objectOutputStream.writeBoolean(this.caching);
        objectOutputStream.writeObject(this.factoryClassLocation);
        objectOutputStream.writeObject(this.identityToken);
        objectOutputStream.writeObject(this.jndiEnv);
        try {
            SerializableUtils.toByteArray((Object)this.jndiName);
            objectOutputStream.writeObject(this.jndiName);
        }
        catch (NotSerializableException notSerializableException) {
            MLog.getLogger(this.getClass()).log(MLevel.FINE, "Direct serialization provoked a NotSerializableException! Trying indirect.", (Throwable)notSerializableException);
            try {
                ReferenceIndirector referenceIndirector = new ReferenceIndirector();
                objectOutputStream.writeObject(referenceIndirector.indirectForm(this.jndiName));
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("Problem indirectly serializing jndiName: " + exception.toString());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        short s = objectInputStream.readShort();
        switch (s) {
            case 1: {
                this.caching = objectInputStream.readBoolean();
                this.factoryClassLocation = (String)objectInputStream.readObject();
                this.identityToken = (String)objectInputStream.readObject();
                this.jndiEnv = (Hashtable)objectInputStream.readObject();
                Object object = objectInputStream.readObject();
                if (object instanceof IndirectlySerialized) {
                    object = ((IndirectlySerialized)object).getObject();
                }
                this.jndiName = object;
                this.pcs = new PropertyChangeSupport(this);
                this.vcs = new VetoableChangeSupport(this);
                break;
            }
            default: {
                throw new IOException("Unsupported Serialized Version: " + s);
            }
        }
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return C3P0ImplUtils.PARENT_LOGGER;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" [ ");
        stringBuffer.append("caching -> " + this.caching);
        stringBuffer.append(", ");
        stringBuffer.append("factoryClassLocation -> " + this.factoryClassLocation);
        stringBuffer.append(", ");
        stringBuffer.append("identityToken -> " + this.identityToken);
        stringBuffer.append(", ");
        stringBuffer.append("jndiEnv -> " + this.jndiEnv);
        stringBuffer.append(", ");
        stringBuffer.append("jndiName -> " + this.jndiName);
        String string = this.extraToStringInfo();
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    protected String extraToStringInfo() {
        return null;
    }

    @Override
    public Reference getReference() throws NamingException {
        return referenceMaker.createReference((Object)this);
    }

    private JndiRefDataSourceBase() {
    }

    public JndiRefDataSourceBase(boolean bl) {
        if (bl) {
            this.identityToken = C3P0ImplUtils.allocateIdentityToken(this);
            C3P0Registry.reregister(this);
        }
    }

    static {
        referenceMaker.setFactoryClassName("com.mchange.v2.c3p0.impl.C3P0JavaBeanObjectFactory");
        referenceMaker.addReferenceProperty("caching");
        referenceMaker.addReferenceProperty("factoryClassLocation");
        referenceMaker.addReferenceProperty("identityToken");
        referenceMaker.addReferenceProperty("jndiEnv");
        referenceMaker.addReferenceProperty("jndiName");
    }
}

