/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.exception;

import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.ExceptionNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.notification.SecurityNotification;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.internal.construct.FlowBackPressureException;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExceptionListener
implements Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExceptionListener.class);
    private static final String NOT_SET = "<not set>";
    private Logger logger = LOGGER;
    private NotificationDispatcher notificationFirer;
    private FlowConstructStatistics statistics;
    private String representation;

    public final synchronized void initialise() throws InitialisationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Initialising exception listener: " + this.toString());
        }
        if (this.representation == null) {
            this.representation = this.getClass().getSimpleName();
        }
    }

    private void fireNotification(Exception ex, CoreEvent event, ComponentLocation componentLocation) {
        if (ex.getCause() != null && this.getCause(ex) instanceof SecurityException) {
            this.fireNotification((Notification)new SecurityNotification((SecurityException)this.getCause(ex), 401));
        } else {
            Component component = null;
            if (ex instanceof MessagingException) {
                component = ((MessagingException)((Object)ex)).getFailingComponent();
            }
            this.fireNotification((Notification)new ExceptionNotification(EnrichedNotificationInfo.createInfo((Event)event, (Exception)ex, (Component)component), componentLocation != null ? componentLocation : componentLocation));
        }
    }

    public void fireNotification(Exception ex, CoreEvent event) {
        this.fireNotification(ex, event, null);
    }

    private Throwable getCause(Exception ex) {
        return ex.getCause() instanceof TypedException ? ex.getCause().getCause() : ex.getCause();
    }

    public Pair<MuleException, String> resolveExceptionAndMessageToLog(Throwable t) {
        MuleException muleException = ExceptionHelper.getRootMuleException((Throwable)t);
        String logMessage = null;
        if (muleException != null) {
            logMessage = !MuleException.isVerboseExceptions() && t instanceof EventProcessingException && ((EventProcessingException)((Object)t)).getEvent().getError().map(e -> Errors.CORE_NAMESPACE_NAME.equals(e.getErrorType().getNamespace()) && "UNKNOWN".equals(e.getErrorType().getIdentifier())).orElse(false) != false ? ((MuleException)ExceptionHelper.sanitize((Throwable)muleException)).getVerboseMessage() : muleException.getDetailedMessage();
        }
        return new Pair((Object)muleException, (Object)logMessage);
    }

    public boolean resolveAndLogException(Throwable t) {
        Pair<MuleException, String> resolvedException = this.resolveExceptionAndMessageToLog(t);
        if (resolvedException.getSecond() == null) {
            this.doLogException("Caught exception in Exception Strategy: " + t.getMessage(), t);
            return true;
        }
        if (((MuleException)resolvedException.getFirst()).getExceptionInfo().isAlreadyLogged() && !(resolvedException.getFirst() instanceof FlowBackPressureException)) {
            return false;
        }
        this.doLogException((String)resolvedException.getSecond(), null);
        ((MuleException)resolvedException.getFirst()).getExceptionInfo().setAlreadyLogged(true);
        return true;
    }

    protected void doLogException(String message, Throwable t) {
        if (t == null) {
            this.logger.error(message);
        } else {
            this.logger.error(message, t);
        }
    }

    public void processStatistics() {
        if (this.statistics != null) {
            this.statistics.incExecutionError();
        }
    }

    protected void logFatal(CoreEvent event, Throwable t) {
        if (this.statistics != null) {
            this.statistics.incFatalError();
        }
        String logUniqueId = StringUtils.defaultString((String)event.getCorrelationId(), (String)NOT_SET);
        String printableLogMessage = MessageFormat.format("Message identification summary here: id={0}, correlation={1}", logUniqueId, event.getGroupCorrelation());
        this.logger.error("Failed to dispatch message to error queue after it failed to process.  This may cause message loss. " + (event.getMessage() == null ? "" : printableLogMessage), t);
    }

    protected void fireNotification(Notification notification) {
        if (this.notificationFirer != null) {
            this.notificationFirer.dispatch(notification);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.debug("notificationFirer is not yet available for firing notifications, ignoring event: " + String.valueOf(notification));
        }
    }

    public void setNotificationFirer(NotificationDispatcher notificationFirer) {
        this.notificationFirer = notificationFirer;
    }

    public void setStatistics(FlowConstructStatistics statistics) {
        this.statistics = statistics;
    }

    public void setRepresentation(String representation) {
        this.representation = representation;
    }

    public String toString() {
        return this.representation;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

