/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.client;

import io.qameta.allure.Issue;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.test.netty.utils.server.HardcodedResponseTcpServer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class ClientBodySemanticsTestCase
extends AbstractMuleTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public HardcodedResponseTcpServer server = new HardcodedResponseTcpServer(this.serverPort.getNumber());
    private HttpClient client;

    @Before
    public void setUp() {
        this.client = NettyHttpClient.builder().build();
        this.client.start();
        this.server.setResponse("HTTP/1.1 200 OK\nContent-Length: 0\n\n");
    }

    @After
    public void tearDown() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    @Issue(value="W-15631517")
    public void noContentLengthHeaderForGetWithoutBodySemantics() throws ExecutionException, InterruptedException {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/hello", this.serverPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpResponse ignored = (HttpResponse)this.client.sendAsync(httpRequest).get();
        List<String> rawRequests = this.server.getReceivedRawRequests();
        MatcherAssert.assertThat(rawRequests, (Matcher)Matchers.hasSize((int)1));
        String rawRequest = rawRequests.get(0);
        MatcherAssert.assertThat((Object)rawRequest, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"content-length: 0")));
    }

    @Test
    @Issue(value="W-15631517")
    public void noContentLengthHeaderForDeleteWithoutBodySemantics() throws ExecutionException, InterruptedException {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/hello", this.serverPort.getNumber())).method("DELETE").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpResponse ignored = (HttpResponse)this.client.sendAsync(httpRequest).get();
        List<String> rawRequests = this.server.getReceivedRawRequests();
        MatcherAssert.assertThat(rawRequests, (Matcher)Matchers.hasSize((int)1));
        String rawRequest = rawRequests.get(0);
        MatcherAssert.assertThat((Object)rawRequest, (Matcher)Matchers.containsString((String)"content-length: 0"));
    }

    @Test
    @Issue(value="W-15631517")
    public void contentLengthHeaderForPostWithEmptyBody() throws ExecutionException, InterruptedException {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/hello", this.serverPort.getNumber())).method("POST").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpResponse ignored = (HttpResponse)this.client.sendAsync(httpRequest).get();
        List<String> rawRequests = this.server.getReceivedRawRequests();
        MatcherAssert.assertThat(rawRequests, (Matcher)Matchers.hasSize((int)1));
        String rawRequest = rawRequests.get(0);
        MatcherAssert.assertThat((Object)rawRequest, (Matcher)Matchers.containsString((String)"content-length: 0"));
    }

    @Test
    @Issue(value="W-15631517")
    public void contentLengthHeaderForPutWithEmptyBody() throws ExecutionException, InterruptedException {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/hello", this.serverPort.getNumber())).method("PUT").entity((HttpEntity)new EmptyHttpEntity())).build();
        HttpResponse ignored = (HttpResponse)this.client.sendAsync(httpRequest).get();
        List<String> rawRequests = this.server.getReceivedRawRequests();
        MatcherAssert.assertThat(rawRequests, (Matcher)Matchers.hasSize((int)1));
        String rawRequest = rawRequests.get(0);
        MatcherAssert.assertThat((Object)rawRequest.toLowerCase(), (Matcher)Matchers.containsString((String)"content-length: 0"));
    }
}

