/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.management.stats;

import java.util.regex.Pattern;

public class ApiKitStatsUtils {
    private static final String APIKIT_FLOWNAME_REGEX = "(\\w*):(\\\\[^:]*)(:[^:]*)?:([^\\/\\\\\\[\\\\\\]\\{\\}#]*)";
    private static final String APIKIT_SOAP_FLOWNAME_REGEX = "(\\w*):\\\\([^\\/\\\\\\[\\\\\\]\\{\\}#]*)";
    private static final Pattern APIKIT_FLOWNAME_PATTERN = Pattern.compile("(\\w*):(\\\\[^:]*)(:[^:]*)?:([^\\/\\\\\\[\\\\\\]\\{\\}#]*)");
    private static final Pattern APIKIT_SOAP_FLOWNAME_PATTERN = Pattern.compile("(\\w*):\\\\([^\\/\\\\\\[\\\\\\]\\{\\}#]*)");

    private ApiKitStatsUtils() {
    }

    public static boolean isApiKitFlow(String flowName) {
        return APIKIT_FLOWNAME_PATTERN.matcher(flowName).matches() || APIKIT_SOAP_FLOWNAME_PATTERN.matcher(flowName).matches();
    }
}

