/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.auth;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.common.client.sse.ProgressiveBodyDataListener;
import org.mule.service.http.netty.impl.client.ReactorNettyClient;
import org.mule.service.http.netty.impl.client.auth.AuthenticationEngine;
import org.mule.service.http.netty.impl.util.MuleToNettyUtils;
import reactor.core.publisher.Flux;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClientResponse;

public class AuthenticationHandler {
    private final ReactorNettyClient httpClient;
    private final AuthenticationEngine authEngine;

    public AuthenticationHandler(ReactorNettyClient client, AuthenticationEngine authHeadersProvider) {
        this.httpClient = client;
        this.authEngine = authHeadersProvider;
    }

    public boolean needsAuth(HttpClientResponse httpResponse, HttpRequestOptions options) {
        Optional authentication = options.getAuthentication();
        return authentication.isPresent() && !this.authEngine.hasFinished() && httpResponse.status().code() == HttpResponseStatus.UNAUTHORIZED.code();
    }

    public Flux<ByteBuf> doHandle(HttpRequest request, HttpRequestOptions requestOptions, HttpClientResponse httpResponse, CompletableFuture<HttpResponse> result, ProgressiveBodyDataListener dataListener) {
        Optional optionalHttpAuthentication = requestOptions.getAuthentication();
        if (!optionalHttpAuthentication.isPresent()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Authentication should be configured to call this method"));
        }
        return this.httpClient.sendAsyncRequest(request, requestOptions, this.getAllHeaders(request, httpResponse, this.authEngine), (response, content) -> {
            if (this.needsAuth((HttpClientResponse)response, requestOptions)) {
                return this.doHandle(request, requestOptions, (HttpClientResponse)response, result, dataListener);
            }
            return this.httpClient.receiveContent((HttpClientResponse)response, (ByteBufFlux)content, result, dataListener);
        }, result);
    }

    private HttpHeaders getAllHeaders(HttpRequest request, HttpClientResponse httpResponse, AuthenticationEngine authenticationHeadersProvider) {
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        MuleToNettyUtils.addAllRequestHeaders(request, (HttpHeaders)httpHeaders, request.getUri());
        if (httpResponse.responseHeaders().contains("WWW-Authenticate")) {
            httpHeaders.add("WWW-Authenticate", (Object)httpResponse.responseHeaders().get("WWW-Authenticate"));
        }
        httpHeaders.add(authenticationHeadersProvider.getAuthHeaders((HttpHeaders)httpHeaders));
        return httpHeaders;
    }
}

