/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorValidation;
import org.mule.runtime.extension.api.error.ErrorMapping;

public class ErrorMappingSourceTypeReferencesNonPropertyValue
extends AbstractErrorValidation {
    public String getName() {
        return "Error Type references fixed";
    }

    public String getDescription() {
        return "Referenced error types are fixed.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(this::errorMappingPresent);
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        Iterator<ErrorMapping> iterator = ErrorMappingSourceTypeReferencesNonPropertyValue.getErrorMappings(component).iterator();
        if (iterator.hasNext()) {
            ErrorMapping errorMapping = iterator.next();
            String errorTypeRawValue = errorMapping.getSource();
            if (MuleAstUtils.hasPropertyPlaceholder((String)errorTypeRawValue)) {
                return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)component.getParameter("Error Mappings", "errorMappings"), (Validation)this, (String)("'" + component.getIdentifier().getName() + "' has 'type' '" + errorTypeRawValue + "' which is resolved with a property and may cause the artifact to have different behavior on different environments.")));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

