/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.sse.server;

import java.net.InetSocketAddress;
import java.util.function.Consumer;
import org.mule.api.annotation.Experimental;
import org.mule.runtime.http.api.domain.request.ClientConnection;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.sse.server.SseClientConfigBuilder;
import org.mule.runtime.http.api.sse.server.SseResponseCustomizer;

@Experimental
public class SseClientConfig {
    private final String clientId;
    private final InetSocketAddress remoteAddress;
    private final Consumer<SseResponseCustomizer> responseCustomizerConsumer;

    public static SseClientConfigBuilder builderFrom(HttpRequestContext requestContext) {
        return SseClientConfig.builder().withRemoteAddress(SseClientConfig.nullSafeGetAddress(requestContext));
    }

    public static SseClientConfigBuilder builder() {
        return new SseClientConfigBuilder();
    }

    SseClientConfig(String clientId, InetSocketAddress remoteHostAddress, Consumer<SseResponseCustomizer> customizerConsumer) {
        this.clientId = clientId;
        this.remoteAddress = remoteHostAddress;
        this.responseCustomizerConsumer = customizerConsumer != null ? customizerConsumer : ignored -> {};
    }

    public String getClientId() {
        return this.clientId;
    }

    public InetSocketAddress getRemoteHostAddress() {
        return this.remoteAddress;
    }

    public Consumer<SseResponseCustomizer> getResponseCustomizerConsumer() {
        return this.responseCustomizerConsumer;
    }

    private static InetSocketAddress nullSafeGetAddress(HttpRequestContext requestContext) {
        if (requestContext == null) {
            return null;
        }
        ClientConnection clientConnection = requestContext.getClientConnection();
        if (clientConnection == null) {
            return null;
        }
        return clientConnection.getRemoteHostAddress();
    }
}

