/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.provider;

import javax.inject.Inject;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.http.api.HttpService;
import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.service.http.netty.impl.service.NettyHttpServiceImplementation;

public class HttpServiceProvider
implements ServiceProvider {
    public static final String IMPLEMENTATION_PROPERTY_NAME = "mule.http.service.implementation";
    public static final String GRIZZLY_IMPLEMENTATION_NAME = "GRIZZLY";
    public static final String NETTY_IMPLEMENTATION_NAME = "NETTY";
    @Inject
    private SchedulerService schedulerService;

    public static String getImplementationName() {
        String implementationName = System.getProperty(IMPLEMENTATION_PROPERTY_NAME, GRIZZLY_IMPLEMENTATION_NAME);
        if (NETTY_IMPLEMENTATION_NAME.equals(implementationName) || GRIZZLY_IMPLEMENTATION_NAME.equals(implementationName)) {
            return implementationName;
        }
        throw new IllegalArgumentException(String.format("Unknown HTTP Service implementation '%s'. Choose 'GRIZZLY' or 'NETTY'", implementationName));
    }

    public ServiceDefinition getServiceDefinition() {
        return new ServiceDefinition(HttpService.class, (Service)this.getImplementation());
    }

    private HttpService getImplementation() {
        String implementationName = HttpServiceProvider.getImplementationName();
        if (NETTY_IMPLEMENTATION_NAME.equals(implementationName)) {
            return new NettyHttpServiceImplementation(this.schedulerService);
        }
        return new HttpServiceImplementation(this.schedulerService);
    }
}

