/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.service.http.netty.impl.streaming.BidirectionalByteBufferStream;
import org.mule.service.http.netty.impl.streaming.CancelableOutputStream;

public class BlockingBidirectionalStream {
    private final ReentrantLock lock;
    private final BidirectionalByteBufferStream bidiBuffer = new BidirectionalByteBufferStream();
    private boolean isClosed = false;
    private Throwable cancellationError;
    private final BlockingInputStreamView inputStream;
    private final BlockingOutputStreamView outputStream;
    private final Condition emptyCondition;

    public BlockingBidirectionalStream() {
        this.lock = new ReentrantLock();
        this.emptyCondition = this.lock.newCondition();
        this.inputStream = new BlockingInputStreamView(this);
        this.outputStream = new BlockingOutputStreamView(this);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public CancelableOutputStream getOutputStream() {
        return this.outputStream;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        try {
            while (this.bidiBuffer.isEmpty() && !this.isClosed && this.cancellationError == null) {
                this.emptyCondition.await();
            }
            if (this.cancellationError != null) {
                throw new IOException("Streaming canceled by writer", this.cancellationError);
            }
            if (this.bidiBuffer.isEmpty()) {
                int e = -1;
                return e;
            }
            int e = this.bidiBuffer.read(b, off, len);
            return e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int read() throws IOException {
        byte[] aux = new byte[1];
        int result = this.read(aux, 0, 1);
        return result == -1 ? -1 : aux[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        try {
            if (this.cancellationError != null) {
                throw new IOException("Trying to write in a canceled stream", this.cancellationError);
            }
            if (this.isClosed) {
                throw new IOException("Trying to write in a closed buffer");
            }
            this.bidiBuffer.write(b, off, len);
            this.emptyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void write(int b) throws IOException {
        byte[] aux = new byte[]{(byte)b};
        this.write(aux, 0, 1);
    }

    public void close() {
        this.lock.lock();
        try {
            this.isClosed = true;
            this.emptyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cancel(Throwable error) {
        this.lock.lock();
        try {
            this.isClosed = true;
            this.cancellationError = error;
            this.emptyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class BlockingInputStreamView
    extends InputStream {
        private final BlockingBidirectionalStream buffer;

        public BlockingInputStreamView(BlockingBidirectionalStream buffer) {
            this.buffer = buffer;
        }

        @Override
        public int read() throws IOException {
            return this.buffer.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.buffer.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.buffer.close();
        }
    }

    private static class BlockingOutputStreamView
    extends CancelableOutputStream {
        private final BlockingBidirectionalStream buffer;

        public BlockingOutputStreamView(BlockingBidirectionalStream buffer) {
            this.buffer = buffer;
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.buffer.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.buffer.close();
        }

        @Override
        public void cancel(Throwable error) {
            this.buffer.cancel(error);
        }
    }
}

