/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;

public class MuleHttpServerExpectContinueHandler
extends HttpServerExpectContinueHandler {
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpRequest req;
        if (msg instanceof HttpRequest && MuleHttpServerExpectContinueHandler.isUnsupportedExpectation((HttpMessage)(req = (HttpRequest)msg))) {
            HttpResponse rejection = this.rejectResponse(req);
            ReferenceCountUtil.release((Object)msg);
            ctx.writeAndFlush((Object)rejection).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            return;
        }
        super.channelRead(ctx, msg);
    }

    private static boolean isUnsupportedExpectation(HttpMessage message) {
        if (!MuleHttpServerExpectContinueHandler.isExpectHeaderValid(message)) {
            return false;
        }
        String expectValue = message.headers().get((CharSequence)HttpHeaderNames.EXPECT);
        return expectValue != null && !HttpHeaderValues.CONTINUE.toString().equalsIgnoreCase(expectValue);
    }

    private static boolean isExpectHeaderValid(HttpMessage message) {
        return message instanceof HttpRequest && message.protocolVersion().compareTo(HttpVersion.HTTP_1_1) >= 0;
    }
}

