/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.service;

import java.util.HashSet;
import java.util.logging.Level;
import org.mule.weave.v2.api.tooling.message.Message;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.service.DebounceLogger$;
import org.mule.weave.v2.model.service.MessageLoggingService;

public final class DefaultMessageLoggingService$
implements MessageLoggingService {
    public static DefaultMessageLoggingService$ MODULE$;
    private final HashSet<String> logOnceCache;

    static {
        new DefaultMessageLoggingService$();
    }

    private HashSet<String> logOnceCache() {
        return this.logOnceCache;
    }

    @Override
    public void logInfo(Message msg, EvaluationContext ctx) {
        ctx.serviceManager().logger().logInfo(msg.getMessage());
    }

    @Override
    public void logWarn(Message msg, EvaluationContext ctx) {
        ctx.serviceManager().logger().logWarn(msg.getMessage());
    }

    @Override
    public void logError(Message msg, EvaluationContext ctx) {
        ctx.serviceManager().logger().logError(msg.getMessage());
    }

    @Override
    public void logInfoDebounce(Message msg, EvaluationContext ctx) {
        DebounceLogger$.MODULE$.log(Level.INFO, msg, ctx);
    }

    @Override
    public void logWarnDebounce(Message msg, EvaluationContext ctx) {
        DebounceLogger$.MODULE$.log(Level.WARNING, msg, ctx);
    }

    @Override
    public void logErrorDebounce(Message msg, EvaluationContext ctx) {
        DebounceLogger$.MODULE$.log(Level.SEVERE, msg, ctx);
    }

    @Override
    public void logInfoOnce(Message msg, EvaluationContext ctx) {
        this.logOnce(msg, 0, ctx);
    }

    private void logOnce(Message msg, int level, EvaluationContext ctx) {
        String kind = msg.getKind();
        if (!this.logOnceCache().contains(kind)) {
            HashSet<String> hashSet = this.logOnceCache();
            synchronized (hashSet) {
                if (!this.logOnceCache().contains(kind)) {
                    this.logOnceCache().add(kind);
                    if (level == 0) {
                        this.logInfo(msg, ctx);
                    } else if (level == 1) {
                        this.logWarn(msg, ctx);
                    } else {
                        this.logError(msg, ctx);
                    }
                }
            }
            return;
        }
    }

    @Override
    public void logWarnOnce(Message msg, EvaluationContext ctx) {
        this.logOnce(msg, 1, ctx);
    }

    @Override
    public void logErrorOnce(Message msg, EvaluationContext ctx) {
        this.logOnce(msg, 2, ctx);
    }

    private DefaultMessageLoggingService$() {
        MODULE$ = this;
        this.logOnceCache = new HashSet();
    }
}

