/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.lang3.StringEscapeUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorRequestHandler
implements RequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorRequestHandler.class);
    private final int statusCode;
    private final String reasonPhrase;
    protected String entityFormat;

    public ErrorRequestHandler(int statusCode, String reasonPhrase, String entityFormat) {
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.entityFormat = entityFormat;
    }

    public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
        String resolvedEntity = this.getResolvedEntity(requestContext.getRequest().getPath());
        responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(this.statusCode)).reasonPhrase(this.reasonPhrase).entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(resolvedEntity.getBytes())))).addHeader("Content-Type", MediaType.TEXT.toRfcString())).build(), new ResponseStatusCallback(){

            public void responseSendFailure(Throwable exception) {
                LOGGER.warn(String.format("Error while sending %s response %s", ErrorRequestHandler.this.statusCode, exception.getMessage()));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("exception thrown", exception);
                }
            }

            public void responseSendSuccessfully() {
            }
        });
    }

    private String getResolvedEntity(String path) {
        return String.format(this.entityFormat, StringEscapeUtils.escapeHtml4((String)path));
    }
}

