/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.server.BaseResponseSender;
import org.mule.service.http.netty.impl.streaming.ResponseStatusCallbackAdapter;
import org.mule.service.http.netty.impl.streaming.StreamingEntitySender;

public class StreamingResponseSender
extends BaseResponseSender {
    private final StreamingEntitySender entitySender;

    public StreamingResponseSender(HttpRequest request, ChannelHandlerContext ctx, HttpResponse response, ResponseStatusCallback statusCallback, ExecutorService ioExecutor) {
        super(request, ctx, response, new ResponseStatusCallbackAdapter(statusCallback));
        Preconditions.checkArgument((boolean)response.getEntity().isStreaming(), (String)"Response entity must be streaming to use a StreamingResponseSender");
        this.entitySender = new StreamingEntitySender(response.getEntity(), ctx, this::sendHeaderIfNeeded, new ResponseStatusCallbackAdapter(statusCallback), ioExecutor);
    }

    @Override
    protected void sendContent() throws IOException {
        this.entitySender.sendNextChunk();
    }
}

