/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.util.AttributeKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.common.client.sse.ProgressiveBodyDataListener;
import org.mule.service.http.netty.impl.client.ChunkedHttpEntityPublisher;
import org.mule.service.http.netty.impl.client.MaxRedirectException;
import org.mule.service.http.netty.impl.message.HttpResponseCreator;
import org.mule.service.http.netty.impl.streaming.BlockingBidirectionalStream;
import org.mule.service.http.netty.impl.streaming.CancelableOutputStream;
import org.mule.service.http.netty.impl.util.HttpUtils;
import org.mule.service.http.netty.impl.util.MuleToNettyUtils;
import org.mule.service.http.netty.impl.util.ReactorNettyUtils;
import org.mule.service.http.netty.impl.util.RedirectHelper;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class ReactorNettyClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactorNettyClient.class);
    private static final int CONTENT_LENGTH_TO_HANDLE_AGGREGATED = DataUnit.KB.toBytes(10);
    private static final int MAX_REDIRECTS = 5;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final Executor ioExecutor;
    private final HttpClient httpClient;
    static final AttributeKey<HttpEntity> REQUEST_ENTITY_KEY = AttributeKey.valueOf((String)"REQUEST_ENTITY");
    static final AttributeKey<Boolean> ALWAYS_SEND_BODY_KEY = AttributeKey.valueOf((String)"ALWAYS_SEND_BODY");
    static final AttributeKey<Boolean> REDIRECT_CHANGE_METHOD = AttributeKey.valueOf((String)"REDIRECT_CHANGE_METHOD");

    public ReactorNettyClient(HttpClient httpClient, Executor ioExecutor) {
        this.httpClient = httpClient;
        this.ioExecutor = ioExecutor;
    }

    public Flux<ByteBuf> sendAsyncRequest(HttpRequest request, HttpRequestOptions options, HttpHeaders headersToAdd, BiFunction<HttpClientResponse, ByteBufFlux, Publisher<ByteBuf>> responseFunction, CompletableFuture<HttpResponse> result) {
        RedirectHelper redirectHelper = new RedirectHelper(headersToAdd);
        URI uri = ReactorNettyClient.uriWithQueryParams(request);
        LOGGER.debug("Sending request to {} with headers {}", (Object)uri, (Object)headersToAdd);
        return ((HttpClient.RequestSender)((HttpClient)this.httpClient.followRedirect((req, res) -> {
            if (req.redirectedFrom().length >= 5) {
                throw new MuleRuntimeException((Throwable)new MaxRedirectException("Max redirects limit reached."));
            }
            return options.isFollowsRedirect();
        }, redirectHelper::addCookiesToRedirectedRequest).doOnRedirect((response, connection) -> redirectHelper.handleRedirectResponse((HttpClientResponse)response)).doOnConnected(connection -> {
            connection.channel().attr(ALWAYS_SEND_BODY_KEY).set((Object)options.shouldSendBodyAlways());
            connection.channel().attr(REDIRECT_CHANGE_METHOD).set((Object)redirectHelper.shouldChangeMethod());
            connection.channel().attr(AttributeKey.valueOf((String)"removeContentLength")).set((Object)MuleToNettyUtils.calculateShouldRemoveContentLength(request));
            if (request.getEntity() != null && this.isExpect(headersToAdd)) {
                connection.channel().attr(REQUEST_ENTITY_KEY).set((Object)request.getEntity());
            }
        })).responseTimeout(Duration.ofMillis(options.getResponseTimeout())).headers(h -> h.add(headersToAdd)).request(HttpMethod.valueOf((String)request.getMethod())).uri(uri)).send((httpClientRequest, nettyOutbound) -> {
            if (this.isExpect(httpClientRequest.requestHeaders())) {
                return nettyOutbound.send((Publisher)Mono.empty());
            }
            if (request.getEntity() != null) {
                return nettyOutbound.send(this.entityPublisher(request.getEntity()));
            }
            return null;
        }).response(responseFunction).onErrorMap(ReactorNettyUtils::onErrorMap).doOnError(result::completeExceptionally).onErrorComplete();
    }

    private boolean isExpect(HttpHeaders entries) {
        return entries.contains("expect");
    }

    private static URI uriWithQueryParams(HttpRequest request) {
        MultiMap queryParams = request.getQueryParams();
        if (queryParams.isEmpty()) {
            return HttpUtils.ensureSchemeAndHost(request.getUri());
        }
        return URI.create(HttpUtils.buildUriString(request.getUri(), (MultiMap<String, String>)queryParams));
    }

    private Publisher<? extends ByteBuf> entityPublisher(HttpEntity entity) {
        if (entity.getBytesLength().isPresent() && entity.getBytesLength().getAsLong() == 0L) {
            return Mono.empty();
        }
        return new ChunkedHttpEntityPublisher(entity);
    }

    public Publisher<ByteBuf> receiveContent(HttpClientResponse response, ByteBufFlux content, CompletableFuture<HttpResponse> result, ProgressiveBodyDataListener dataListener) {
        LOGGER.debug("Received response with headers {} and status {}", (Object)response.responseHeaders(), (Object)response.status());
        if (this.responseIsShortEnough(response)) {
            return this.handleShortResponse(response, content, result, dataListener);
        }
        return this.handleResponseStreaming(response, content, result, dataListener);
    }

    private Publisher<ByteBuf> handleResponseStreaming(HttpClientResponse response, ByteBufFlux content, CompletableFuture<HttpResponse> result, ProgressiveBodyDataListener dataListener) {
        try {
            BlockingBidirectionalStream bidirectionalStream = new BlockingBidirectionalStream();
            InputStream in = bidirectionalStream.getInputStream();
            dataListener.onStreamCreated(in);
            CancelableOutputStream out = bidirectionalStream.getOutputStream();
            Flux contentFlux = content.retain().doOnNext(data -> {
                try {
                    byte[] bytes = new byte[data.readableBytes()];
                    data.readBytes(bytes);
                    out.write(bytes);
                    data.release();
                    if (!result.isDone()) {
                        LOGGER.debug("Marked response as completed but still waiting on content");
                        result.completeAsync(() -> new HttpResponseCreator().create(response, in), this.ioExecutor);
                    }
                    dataListener.onDataAvailable(bytes.length);
                }
                catch (IOException e) {
                    result.completeExceptionally(e);
                    data.release();
                }
            }).doOnComplete(() -> {
                try {
                    LOGGER.debug("Marked response as completed");
                    out.close();
                    if (!result.isDone()) {
                        result.completeAsync(() -> new HttpResponseCreator().create(response, in), this.ioExecutor);
                    }
                    dataListener.onEndOfStream();
                }
                catch (Exception e) {
                    result.completeExceptionally(e);
                }
            }).doOnError(error -> {
                Throwable mappedError = ReactorNettyUtils.onErrorMap(error);
                out.cancel(mappedError);
                result.completeExceptionally(mappedError);
                dataListener.onEndOfStream();
            });
            if (!result.isDone()) {
                result.completeAsync(() -> new HttpResponseCreator().create(response, in), this.ioExecutor);
            }
            return contentFlux;
        }
        catch (Exception e) {
            result.completeExceptionally(e);
            return content;
        }
    }

    private Publisher<ByteBuf> handleShortResponse(HttpClientResponse response, ByteBufFlux content, CompletableFuture<HttpResponse> result, ProgressiveBodyDataListener dataListener) {
        return content.aggregate().doOnError(error -> result.completeExceptionally(ReactorNettyUtils.onErrorMap(error))).doOnSuccess(byteBuf -> {
            ByteArrayInputStream inputStream;
            int readable;
            int n = readable = byteBuf == null ? 0 : byteBuf.readableBytes();
            if (readable == 0) {
                inputStream = new ByteArrayInputStream(EMPTY_BYTES);
            } else {
                int readerIndex = byteBuf.readerIndex();
                if (byteBuf.hasArray()) {
                    inputStream = new ByteArrayInputStream(byteBuf.array(), byteBuf.arrayOffset() + readerIndex, readable);
                } else {
                    byte[] bytes = new byte[readable];
                    byteBuf.getBytes(readerIndex, bytes);
                    inputStream = new ByteArrayInputStream(bytes);
                }
            }
            result.complete(new HttpResponseCreator().create(response, (InputStream)inputStream));
            dataListener.onStreamCreated(inputStream);
            dataListener.onDataAvailable(readable);
            dataListener.onEndOfStream();
        });
    }

    private boolean responseIsShortEnough(HttpClientResponse response) {
        String contentLength = response.responseHeaders().get("Content-Length");
        if (contentLength == null) {
            return false;
        }
        return Integer.parseInt(contentLength) < CONTENT_LENGTH_TO_HANDLE_AGGREGATED;
    }
}

