/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata.chain;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.RouterOutputMetadataContext;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;

public class OneOfRoutesOutputTypeResolver
implements OutputTypeResolver<Object>,
AttributesTypeResolver<Object> {
    public static final OneOfRoutesOutputTypeResolver INSTANCE = new OneOfRoutesOutputTypeResolver();

    private OneOfRoutesOutputTypeResolver() {
    }

    public String getCategoryName() {
        return "OUTPUT_ROUTER_DYNAMIC";
    }

    public String getResolverName() {
        return "ONE_OF_ROUTES";
    }

    public MetadataType getOutputType(MetadataContext context, Object key) throws MetadataResolvingException, ConnectionException {
        return this.union(context, MessageMetadataType::getPayloadType);
    }

    public MetadataType getAttributesType(MetadataContext context, Object key) throws MetadataResolvingException, ConnectionException {
        return this.union(context, MessageMetadataType::getAttributesType);
    }

    private MetadataType union(MetadataContext context, Function<MessageMetadataType, Optional<MetadataType>> extractor) throws MetadataResolvingException {
        UnionTypeBuilder builder = context.getTypeBuilder().unionType().flattens().removesRepetitions();
        Map routes = context.getRouterOutputMetadataContext().map(RouterOutputMetadataContext::getRouteOutputMessageTypes).orElseThrow(() -> new MetadataResolvingException("Route propagation context not available", FailureCode.UNKNOWN));
        if (routes.isEmpty()) {
            return MuleExtensionModelProvider.VOID_TYPE;
        }
        routes.values().forEach(route -> {
            MetadataType type = ((Optional)extractor.apply((MessageMetadataType)route.get())).orElse(MuleExtensionModelProvider.VOID_TYPE);
            builder.of(type);
        });
        UnionType result = builder.build();
        if (result.getTypes().size() > 1) {
            return result;
        }
        return (MetadataType)result.getTypes().get(0);
    }
}

