/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.service;

import java.util.function.Supplier;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.service.http.netty.impl.server.ContextHttpServerConnectionFactory;

public class ContextHttpServerFactory
implements HttpServerFactory {
    private final ContextHttpServerConnectionFactory delegate;
    private final Supplier<Long> shutdownTimeout;
    private final String context;
    private final String parentContext;

    public ContextHttpServerFactory(ContextHttpServerConnectionFactory delegate, String context, String parentContext, Supplier<Long> shutdownTimeout) {
        this.delegate = delegate;
        this.context = context;
        this.parentContext = parentContext;
        this.shutdownTimeout = shutdownTimeout;
    }

    public HttpServer create(HttpServerConfiguration configuration) throws ServerCreationException {
        return this.delegate.create(configuration, this.context, this.shutdownTimeout);
    }

    public HttpServer lookup(String name) throws ServerNotFoundException {
        try {
            return this.delegate.lookup(name, this.context);
        }
        catch (ServerNotFoundException e) {
            if (this.parentContext != null) {
                return this.delegate.lookup(name, this.parentContext);
            }
            throw e;
        }
    }

    public String getContextName() {
        return this.context;
    }

    public String getParentContextName() {
        return this.parentContext;
    }
}

