/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import io.netty.util.DefaultAttributeMap;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.service.http.netty.impl.util.HttpLoggingHandler;
import org.mule.service.http.test.netty.impl.util.NettyLoggerRule;
import org.mule.tck.junit4.AbstractMuleTestCase;
import reactor.netty.Connection;

public class HttpLoggingHandlerTestCase
extends AbstractMuleTestCase {
    private static final AttributeKey<Connection> CONNECTION = AttributeKey.valueOf((String)"$CONNECTION");
    private static final String LEGACY_WIRE_LOGGING_CLASS_NAME = "org.mule.service.http.impl.service.HttpMessageLogger";
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Rule
    public NettyLoggerRule loggerRule = new NettyLoggerRule();
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private Channel channel;
    @Mock
    private Connection connection;
    private HttpLoggingHandler loggingHandler;

    @Before
    public void setup() {
        DefaultAttributeMap attributeMap = new DefaultAttributeMap();
        attributeMap.attr(CONNECTION).set((Object)this.connection);
        Mockito.when((Object)this.channel.hasAttr(CONNECTION)).thenReturn((Object)true);
        Mockito.when((Object)this.channel.attr(CONNECTION)).thenReturn((Object)attributeMap.attr(CONNECTION));
        Mockito.when((Object)this.channel.toString()).thenReturn((Object)"[id: 0x1234]");
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
        this.loggingHandler = new HttpLoggingHandler();
    }

    @Test
    public void logChannelRead() throws Exception {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "https://www.salesforce.org/test", HttpLoggingHandlerTestCase.asByteBuf("Hello test!"));
        this.loggingHandler.channelRead(this.ctx, (Object)request);
        List<String> debugLogs = this.loggerRule.getDebugLogs(LEGACY_WIRE_LOGGING_CLASS_NAME);
        MatcherAssert.assertThat(debugLogs, (Matcher)Matchers.contains((Object[])new String[]{"[1234] READ: 11B Hello test!"}));
    }

    @Test
    public void logWrite() throws Exception {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, HttpLoggingHandlerTestCase.asByteBuf("Hello test!"));
        this.loggingHandler.write(this.ctx, (Object)response, (ChannelPromise)new DefaultChannelPromise(this.channel));
        List<String> debugLogs = this.loggerRule.getDebugLogs(LEGACY_WIRE_LOGGING_CLASS_NAME);
        MatcherAssert.assertThat(debugLogs, (Matcher)Matchers.contains((Object[])new String[]{"[1234] WRITE: 11B Hello test!"}));
    }

    @Test
    public void logFlush() throws Exception {
        this.loggingHandler.flush(this.ctx);
        List<String> debugLogs = this.loggerRule.getDebugLogs(LEGACY_WIRE_LOGGING_CLASS_NAME);
        MatcherAssert.assertThat(debugLogs, (Matcher)Matchers.contains((Object[])new String[]{"[1234] FLUSH"}));
    }

    @Test
    public void logConnect() throws Exception {
        InetSocketAddress localAddress = new InetSocketAddress(8080);
        InetSocketAddress remoteAddress = new InetSocketAddress(8081);
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
        this.loggingHandler.connect(this.ctx, (SocketAddress)remoteAddress, (SocketAddress)localAddress, (ChannelPromise)promise);
        List<String> debugLogs = this.loggerRule.getDebugLogs(LEGACY_WIRE_LOGGING_CLASS_NAME);
        MatcherAssert.assertThat(debugLogs, (Matcher)Matchers.contains((Object[])new String[]{"[1234] CONNECT: 0.0.0.0/0.0.0.0:8081, 0.0.0.0/0.0.0.0:8080"}));
    }

    @Test
    public void logClose() throws Exception {
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
        this.loggingHandler.close(this.ctx, (ChannelPromise)promise);
        List<String> debugLogs = this.loggerRule.getDebugLogs(LEGACY_WIRE_LOGGING_CLASS_NAME);
        MatcherAssert.assertThat(debugLogs, (Matcher)Matchers.contains((Object[])new String[]{"[1234] CLOSE"}));
    }

    private static ByteBuf asByteBuf(String string) {
        ByteBuf byteBuf = Unpooled.buffer((int)string.length());
        byteBuf.writeBytes(string.getBytes());
        return byteBuf;
    }
}

