/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.server;

import com.sun.mail.util.LineInputStream;
import io.qameta.allure.Story;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.server.AbstractHttpServerTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

@Story(value="Multipart")
public class HttpServerPartsTestCase
extends AbstractHttpServerTestCase {
    private static final String MIME_UTF_PROPERTY = "mail.mime.allowutf8";
    private static final String MIME_PROPERTY_READ_FIELD_NAME = "defaultutf8";
    private static final String TEXT_BODY_FIELD_NAME = "field1";
    private static final String TEXT_BODY_FIELD_VALUE = "yes";
    private static final String BASE_PATH = "/";
    private static final String NO_HEADER = "/no-header";
    private static final String PARTIAL_HEADER = "/partial-header";
    private static final String FULL_HEADER = "/full-header";
    private static final String UTF = "/utf";
    private static final String BOUNDARY_PART = "; boundary=\"the-boundary\"";
    private static final String MIXED_CONTENT = "--the-boundary\r\nContent-Type: text/plain; charset=ISO-8859-1\r\nContent-Transfer-Encoding: 8bit\r\nContent-Disposition: inline; name=\"field1\"; filename=\"\u00a310.txt\" \r\n\r\nyes\r\n--the-boundary--\r\n";
    @Rule
    public SystemProperty encoding = new SystemProperty("mail.mime.allowutf8", "true");

    public HttpServerPartsTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setUp() throws Exception {
        this.setUpServer();
        AbstractHttpServiceTestCase.IgnoreResponseStatusCallback statusCallback = new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback();
        this.server.addRequestHandler(BASE_PATH, (requestContext, responseCallback) -> {
            try {
                Collection parts = requestContext.getRequest().getEntity().getParts();
                responseCallback.responseReady(((HttpResponseBuilder)HttpResponse.builder().entity((org.mule.runtime.http.api.domain.entity.HttpEntity)new MultipartHttpEntity(parts))).build(), (ResponseStatusCallback)statusCallback);
            }
            catch (IOException e) {
                responseCallback.responseReady(HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).build(), (ResponseStatusCallback)statusCallback);
            }
        });
        this.server.addRequestHandler(UTF, (requestContext, responseCallback) -> {
            try {
                Collection parts = requestContext.getRequest().getEntity().getParts();
                responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((org.mule.runtime.http.api.domain.entity.HttpEntity)new MultipartHttpEntity(parts))).addHeader("Content-Type", requestContext.getRequest().getHeaderValue("Content-Type"))).build(), (ResponseStatusCallback)statusCallback);
            }
            catch (IOException e) {
                responseCallback.responseReady(HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).build(), (ResponseStatusCallback)statusCallback);
            }
        });
        this.server.addRequestHandler(NO_HEADER, (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)HttpResponse.builder().entity((org.mule.runtime.http.api.domain.entity.HttpEntity)new MultipartHttpEntity(this.createPart()))).build(), (ResponseStatusCallback)statusCallback));
        this.server.addRequestHandler(PARTIAL_HEADER, (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((org.mule.runtime.http.api.domain.entity.HttpEntity)new MultipartHttpEntity(this.createPart()))).addHeader("Content-Type", "multipart/form-data")).build(), (ResponseStatusCallback)statusCallback));
        this.server.addRequestHandler(FULL_HEADER, (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((org.mule.runtime.http.api.domain.entity.HttpEntity)new MultipartHttpEntity(this.createPart()))).addHeader("Content-Type", "multipart/form-data; boundary=\"the-boundary\"")).build(), (ResponseStatusCallback)statusCallback));
    }

    @Override
    protected String getServerName() {
        return "parts-test";
    }

    @Test
    public void returnsOnlyOneContentTypeHeaderPerPart() throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(this.getUri(BASE_PATH));
            httpPost.setEntity(this.getMultipartEntity());
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent());
                MatcherAssert.assertThat((String)responseContent, (Object)StringUtils.countMatches((CharSequence)responseContent, (CharSequence)"Content-Type"), (Matcher)Is.is((Object)1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void utf8InHeaders() throws Exception {
        Optional<Field> utf8Property = this.getMailProperty();
        Boolean previousValue = null;
        if (utf8Property.isPresent()) {
            utf8Property.get().setAccessible(true);
            previousValue = utf8Property.get().getBoolean(null);
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            if (utf8Property.isPresent()) {
                utf8Property.get().setBoolean(null, Boolean.getBoolean(MIME_UTF_PROPERTY));
            }
            HttpPost httpPost = new HttpPost(this.getUri(UTF));
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(MIXED_CONTENT.getBytes(), ContentType.create((String)"multipart/mixed", (Charset)Consts.ISO_8859_1).withParameters(new NameValuePair[]{new BasicNameValuePair("boundary", "the-boundary")})));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                ContentType.parse((String)response.getFirstHeader("content-type").getValue()).getParameter("boundary");
                MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Is.is((Object)MIXED_CONTENT));
            }
        }
        finally {
            if (previousValue != null) {
                utf8Property.get().setBoolean(null, previousValue);
            }
        }
    }

    private Optional<Field> getMailProperty() {
        try {
            return Optional.of(LineInputStream.class.getDeclaredField(MIME_PROPERTY_READ_FIELD_NAME));
        }
        catch (NoSuchFieldException e) {
            return Optional.empty();
        }
    }

    @Test
    public void maintainsBoundaryWhenPresent() throws Exception {
        this.assertBoundaryMatch(FULL_HEADER, BOUNDARY_PART);
    }

    @Test
    public void addsBoundaryWhenNoHeaderIsPresent() throws Exception {
        this.assertBoundaryMatch(NO_HEADER, "; boundary=\"");
    }

    @Test
    public void addsBoundaryWhenNotPresent() throws Exception {
        this.assertBoundaryMatch(PARTIAL_HEADER, "; boundary=\"");
    }

    private void assertBoundaryMatch(String path, String boundaryPart) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(this.getUri(path));
            httpPost.setEntity(this.getMultipartEntity());
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                String contentType = response.getFirstHeader("Content-Type").getValue();
                MatcherAssert.assertThat((Object)contentType, (Matcher)Matchers.startsWith((String)"multipart/form-data"));
                MatcherAssert.assertThat((Object)contentType, (Matcher)Matchers.containsString((String)boundaryPart));
            }
        }
    }

    private String getUri(String path) {
        return String.format("http://localhost:%s%s", this.port.getNumber(), path);
    }

    private Collection<HttpPart> createPart() {
        HttpPart part = new HttpPart(TEXT_BODY_FIELD_NAME, TEXT_BODY_FIELD_VALUE.getBytes(), "text/plain", TEXT_BODY_FIELD_VALUE.length());
        return Collections.singletonList(part);
    }

    private HttpEntity getMultipartEntity() {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody(TEXT_BODY_FIELD_NAME, TEXT_BODY_FIELD_VALUE, ContentType.TEXT_PLAIN);
        return builder.build();
    }
}

