/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RejectionCallbackExecutorServiceDecorator
implements ScheduledExecutorService {
    private final ScheduledExecutorService delegate;
    private final ScheduledExecutorService retryScheduler;
    private final Runnable onRejected;
    private final Runnable onRetrySuccessful;
    private final Duration retryInterval;

    public RejectionCallbackExecutorServiceDecorator(ScheduledExecutorService executorService, ScheduledExecutorService retryScheduler, Runnable onRejected, Runnable onRetrySuccessful, Duration retryInterval) {
        this.delegate = executorService;
        this.retryScheduler = retryScheduler;
        this.onRejected = onRejected;
        this.onRetrySuccessful = onRetrySuccessful;
        this.retryInterval = retryInterval;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        try {
            return this.delegate.submit(task);
        }
        catch (RejectedExecutionException ree) {
            this.onRejected.run();
            CompletableFuture retryedFuture = new CompletableFuture();
            this.retryScheduler.schedule(() -> {
                if (task instanceof RetriedCallable) {
                    this.submit(task);
                } else {
                    this.submit(() -> {
                        try {
                            Object call = task.call();
                            retryedFuture.complete(call);
                            return call;
                        }
                        catch (Exception e) {
                            retryedFuture.completeExceptionally(e);
                            throw e;
                        }
                    });
                }
            }, this.retryInterval.toMillis(), TimeUnit.MILLISECONDS);
            return retryedFuture.thenApply(r -> {
                this.onRetrySuccessful.run();
                return r;
            });
        }
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        try {
            return this.delegate.submit(task, result);
        }
        catch (RejectedExecutionException e) {
            this.onRejected.run();
            CompletableFuture retryedFuture = new CompletableFuture();
            this.retryScheduler.schedule(() -> {
                if (task instanceof RetriedRunnable) {
                    this.submit(task);
                } else {
                    this.submit(() -> {
                        task.run();
                        retryedFuture.complete(null);
                    }, result);
                }
            }, this.retryInterval.toMillis(), TimeUnit.MILLISECONDS);
            return retryedFuture.thenApply(r -> {
                this.onRetrySuccessful.run();
                return r;
            });
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        try {
            return this.delegate.submit(task);
        }
        catch (RejectedExecutionException e) {
            this.onRejected.run();
            CompletableFuture retryedFuture = new CompletableFuture();
            this.retryScheduler.schedule(() -> {
                if (task instanceof RetriedRunnable) {
                    this.submit(task);
                } else {
                    this.submit(() -> {
                        task.run();
                        retryedFuture.complete(null);
                    });
                }
            }, this.retryInterval.toMillis(), TimeUnit.MILLISECONDS);
            return retryedFuture.thenApply(r -> {
                this.onRetrySuccessful.run();
                return r;
            });
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.delegate.execute(command);
        }
        catch (RejectedExecutionException e) {
            this.onRejected.run();
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.delegate.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.delegate.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.delegate.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.delegate.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    private static interface RetriedRunnable
    extends Runnable {
    }

    private static interface RetriedCallable<T>
    extends Callable<T> {
    }
}

