/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.auth.ntlm.message;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Cipher;
import org.mule.service.http.netty.impl.client.auth.ntlm.av.AvFlags;
import org.mule.service.http.netty.impl.client.auth.ntlm.av.AvPair;
import org.mule.service.http.netty.impl.client.auth.ntlm.av.AvPairs;
import org.mule.service.http.netty.impl.client.auth.ntlm.av.AvSingleHost;
import org.mule.service.http.netty.impl.client.auth.ntlm.av.AvTargetName;
import org.mule.service.http.netty.impl.client.auth.ntlm.av.AvTimestamp;
import org.mule.service.http.netty.impl.client.auth.ntlm.message.NtlmMessage;
import org.mule.service.http.netty.impl.client.auth.ntlm.message.Type2Message;
import org.mule.service.http.netty.impl.client.auth.ntlm.smb.NtlmUtil;
import org.mule.service.http.netty.impl.client.auth.ntlm.util.Crypto;

public class Type3Message
extends NtlmMessage {
    private byte[] masterKey;
    private String domain;
    private String user;
    private String workstation;
    private byte[] lmResponse;
    private byte[] ntResponse;
    private byte[] mic = null;
    private boolean micRequired;
    private byte[] sessionKey;

    public Type3Message(Type2Message type2, String targetName, byte[] passwordHash, String password, String domain, String user, String workstation, int flags, boolean nonAnonymous) throws GeneralSecurityException {
        byte[] ntlmClientChallengeInfo;
        List<AvPair> avPairs;
        boolean haveTimestamp;
        this.setFlags(flags | this.getDefaultFlags(type2));
        this.setWorkstation(workstation);
        this.setDomain(domain);
        this.setUser(user);
        SecureRandom secureRandom = new SecureRandom();
        if (password == null && passwordHash == null || !nonAnonymous && password != null && password.length() == 0) {
            this.setLMResponse(null);
            this.setNTResponse(null);
            return;
        }
        if (passwordHash == null) {
            passwordHash = NtlmUtil.getNTHash(password);
        }
        if (!(haveTimestamp = AvPairs.contains(avPairs = (ntlmClientChallengeInfo = type2.getTargetInformation()) != null ? AvPairs.decode(ntlmClientChallengeInfo) : null, 7))) {
            byte[] lmClientChallenge = new byte[8];
            secureRandom.nextBytes(lmClientChallenge);
            this.setLMResponse(Type3Message.getLMv2Response(type2, domain, user, passwordHash, lmClientChallenge));
        } else {
            this.setLMResponse(new byte[24]);
        }
        if (avPairs != null) {
            this.setFlag(0x800000, true);
        }
        byte[] responseKeyNT = NtlmUtil.nTOWFv2(domain, user, passwordHash);
        byte[] ntlmClientChallenge = new byte[8];
        secureRandom.nextBytes(ntlmClientChallenge);
        long ts = (System.currentTimeMillis() + 11644473600000L) * 10000L;
        if (haveTimestamp) {
            ts = ((AvTimestamp)AvPairs.get(avPairs, 7)).getTimestamp();
        }
        this.setNTResponse(Type3Message.getNTLMv2Response(type2, responseKeyNT, ntlmClientChallenge, this.makeAvPairs(targetName, avPairs, haveTimestamp, ts), ts));
        MessageDigest hmac = Crypto.getHMACT64(responseKeyNT);
        hmac.update(this.ntResponse, 0, 16);
        byte[] userSessionKey = hmac.digest();
        if (this.getFlag(0x40000000)) {
            this.masterKey = new byte[16];
            secureRandom.nextBytes(this.masterKey);
            byte[] encryptedKey = new byte[16];
            Cipher rc4 = Crypto.getArcfour(userSessionKey);
            rc4.update(this.masterKey, 0, 16, encryptedKey, 0);
            this.setEncryptedSessionKey(encryptedKey);
        } else {
            this.masterKey = userSessionKey;
        }
    }

    public static byte[] getLMv2Response(Type2Message type2, String domain, String user, byte[] passwordHash, byte[] clientChallenge) throws GeneralSecurityException {
        if (type2 == null || domain == null || user == null || passwordHash == null || clientChallenge == null) {
            return null;
        }
        return NtlmUtil.getLMv2Response(domain, user, passwordHash, type2.getChallenge(), clientChallenge);
    }

    private int getDefaultFlags(Type2Message type2) {
        int flags = 0x2000200;
        return flags |= type2.getFlag(1) ? 1 : 2;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public void setWorkstation(String workstation) {
        this.workstation = workstation;
    }

    public byte[] getLMResponse() {
        return this.lmResponse;
    }

    public void setLMResponse(byte[] lmResponse) {
        this.lmResponse = lmResponse;
    }

    public byte[] getNTResponse() {
        return this.ntResponse;
    }

    public void setNTResponse(byte[] ntResponse) {
        this.ntResponse = ntResponse;
    }

    public static byte[] getNTLMv2Response(Type2Message type2, byte[] responseKeyNT, byte[] clientChallenge, byte[] clientChallengeInfo, long ts) throws NoSuchAlgorithmException {
        if (type2 == null || responseKeyNT == null || clientChallenge == null) {
            return null;
        }
        return NtlmUtil.getNTLMv2Response(responseKeyNT, type2.getChallenge(), clientChallenge, ts, clientChallengeInfo);
    }

    private byte[] makeAvPairs(String targetName, List<AvPair> serverAvPairs, boolean haveServerTimestamp, long ts) {
        if (serverAvPairs == null) {
            serverAvPairs = new LinkedList<AvPair>();
        }
        if (this.getFlag(16) && haveServerTimestamp) {
            this.micRequired = true;
            this.mic = new byte[16];
            int curFlags = 0;
            AvFlags cur = (AvFlags)AvPairs.get(serverAvPairs, 6);
            if (cur != null) {
                curFlags = cur.getFlags();
            }
            AvPairs.replace(serverAvPairs, new AvFlags(curFlags |= 2));
        }
        AvPairs.replace(serverAvPairs, new AvTimestamp(ts));
        if (targetName != null) {
            AvPairs.replace(serverAvPairs, new AvTargetName(targetName));
        }
        AvPairs.replace(serverAvPairs, new AvPair(10, new byte[16]));
        AvPairs.replace(serverAvPairs, new AvSingleHost(this.getMachineId()));
        return AvPairs.encode(serverAvPairs);
    }

    private byte[] getMachineId() {
        byte[] mid = new byte[32];
        new SecureRandom().nextBytes(mid);
        return mid;
    }

    public void setEncryptedSessionKey(byte[] sessionKey) {
        this.sessionKey = sessionKey;
    }

    public byte[] toByteArray() throws UnsupportedEncodingException {
        byte[] micBytes;
        int size = 64;
        boolean unicode = this.getFlag(1);
        String oemCp = unicode ? null : Type3Message.getOEMEncoding();
        String domainName = this.getDomain();
        byte[] domainBytes = null;
        if (domainName != null && domainName.length() != 0) {
            domainBytes = unicode ? domainName.getBytes("UTF-16LE") : domainName.getBytes(oemCp);
            size += domainBytes.length;
        }
        String userName = this.getUser();
        byte[] userBytes = null;
        if (userName != null && userName.length() != 0) {
            userBytes = unicode ? userName.getBytes("UTF-16LE") : userName.toUpperCase().getBytes(oemCp);
            size += userBytes.length;
        }
        String workstationName = this.getWorkstation();
        byte[] workstationBytes = null;
        if (workstationName != null && workstationName.length() != 0) {
            workstationBytes = unicode ? workstationName.getBytes("UTF-16LE") : workstationName.toUpperCase().getBytes(oemCp);
            size += workstationBytes.length;
        }
        if ((micBytes = this.getMic()) != null) {
            size += 24;
        } else if (this.getFlag(0x2000000)) {
            size += 8;
        }
        byte[] lmResponseBytes = this.getLMResponse();
        size += lmResponseBytes != null ? lmResponseBytes.length : 0;
        byte[] ntResponseBytes = this.getNTResponse();
        size += ntResponseBytes != null ? ntResponseBytes.length : 0;
        byte[] sessionKeyBytes = this.getEncryptedSessionKey();
        byte[] type3 = new byte[size += sessionKeyBytes != null ? sessionKeyBytes.length : 0];
        int pos = 0;
        System.arraycopy(NTLMSSP_SIGNATURE, 0, type3, 0, 8);
        Type3Message.writeULong(type3, pos += 8, 3);
        pos += 4;
        int lmOff = Type3Message.writeSecurityBuffer(type3, 12, lmResponseBytes);
        pos += 8;
        int ntOff = Type3Message.writeSecurityBuffer(type3, 20, ntResponseBytes);
        pos += 8;
        int domOff = Type3Message.writeSecurityBuffer(type3, 28, domainBytes);
        pos += 8;
        int userOff = Type3Message.writeSecurityBuffer(type3, 36, userBytes);
        pos += 8;
        int wsOff = Type3Message.writeSecurityBuffer(type3, 44, workstationBytes);
        pos += 8;
        int skOff = Type3Message.writeSecurityBuffer(type3, 52, sessionKeyBytes);
        Type3Message.writeULong(type3, pos += 8, this.getFlags());
        pos += 4;
        if (this.getFlag(0x2000000)) {
            System.arraycopy(NTLMSSP_VERSION, 0, type3, pos, NTLMSSP_VERSION.length);
            pos += NTLMSSP_VERSION.length;
        } else if (micBytes != null) {
            pos += NTLMSSP_VERSION.length;
        }
        if (micBytes != null) {
            System.arraycopy(micBytes, 0, type3, pos, 16);
            pos += 16;
        }
        pos += Type3Message.writeSecurityBufferContent(type3, pos, lmOff, lmResponseBytes);
        pos += Type3Message.writeSecurityBufferContent(type3, pos, ntOff, ntResponseBytes);
        pos += Type3Message.writeSecurityBufferContent(type3, pos, domOff, domainBytes);
        pos += Type3Message.writeSecurityBufferContent(type3, pos, userOff, userBytes);
        pos += Type3Message.writeSecurityBufferContent(type3, pos, wsOff, workstationBytes);
        Type3Message.writeSecurityBufferContent(type3, pos, skOff, sessionKeyBytes);
        return type3;
    }

    private byte[] getEncryptedSessionKey() {
        return this.sessionKey;
    }

    private byte[] getMic() {
        return this.mic;
    }
}

