/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.parsson.JsonContext;
import org.eclipse.parsson.JsonMessages;
import org.eclipse.parsson.JsonNumberImpl;
import org.eclipse.parsson.JsonStringImpl;
import org.eclipse.parsson.JsonWriterImpl;
import org.eclipse.parsson.MapUtil;

class JsonArrayBuilderImpl
implements JsonArrayBuilder {
    private ArrayList<JsonValue> valueList;
    private final JsonContext jsonContext;

    JsonArrayBuilderImpl(JsonContext jsonContext) {
        this.jsonContext = jsonContext;
    }

    JsonArrayBuilderImpl(JsonArray array, JsonContext jsonContext) {
        this(jsonContext);
        this.valueList = new ArrayList();
        this.valueList.addAll((Collection<JsonValue>)array);
    }

    JsonArrayBuilderImpl(Collection<?> collection, JsonContext jsonContext) {
        this(jsonContext);
        this.valueList = new ArrayList();
        this.populate(collection);
    }

    public JsonArrayBuilder add(JsonValue value) {
        this.validateValue(value);
        this.addValueList(value);
        return this;
    }

    public JsonArrayBuilder add(String value) {
        this.validateValue(value);
        this.addValueList((JsonValue)new JsonStringImpl(value));
        return this;
    }

    public JsonArrayBuilder add(BigDecimal value) {
        this.validateValue(value);
        this.addValueList((JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder add(BigInteger value) {
        this.validateValue(value);
        this.addValueList((JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder add(int value) {
        this.addValueList((JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder add(long value) {
        this.addValueList((JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder add(double value) {
        this.addValueList((JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder add(boolean value) {
        this.addValueList(value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    public JsonArrayBuilder addNull() {
        this.addValueList(JsonValue.NULL);
        return this;
    }

    public JsonArrayBuilder add(JsonObjectBuilder builder) {
        if (builder == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_OBJECT_BUILDER_NULL());
        }
        this.addValueList((JsonValue)builder.build());
        return this;
    }

    public JsonArrayBuilder add(JsonArrayBuilder builder) {
        if (builder == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_ARRAY_BUILDER_NULL());
        }
        this.addValueList((JsonValue)builder.build());
        return this;
    }

    public JsonArrayBuilder addAll(JsonArrayBuilder builder) {
        if (builder == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_ARRAY_BUILDER_NULL());
        }
        if (this.valueList == null) {
            this.valueList = new ArrayList();
        }
        this.valueList.addAll((Collection<JsonValue>)builder.build());
        return this;
    }

    public JsonArrayBuilder add(int index, JsonValue value) {
        this.validateValue(value);
        this.addValueList(index, value);
        return this;
    }

    public JsonArrayBuilder add(int index, String value) {
        this.validateValue(value);
        this.addValueList(index, (JsonValue)new JsonStringImpl(value));
        return this;
    }

    public JsonArrayBuilder add(int index, BigDecimal value) {
        this.validateValue(value);
        this.addValueList(index, (JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder add(int index, BigInteger value) {
        this.validateValue(value);
        this.addValueList(index, (JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder add(int index, int value) {
        this.addValueList(index, (JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder add(int index, long value) {
        this.addValueList(index, (JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder add(int index, double value) {
        this.addValueList(index, (JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder add(int index, boolean value) {
        this.addValueList(index, value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    public JsonArrayBuilder addNull(int index) {
        this.addValueList(index, JsonValue.NULL);
        return this;
    }

    public JsonArrayBuilder add(int index, JsonObjectBuilder builder) {
        if (builder == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_OBJECT_BUILDER_NULL());
        }
        this.addValueList(index, (JsonValue)builder.build());
        return this;
    }

    public JsonArrayBuilder add(int index, JsonArrayBuilder builder) {
        if (builder == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_OBJECT_BUILDER_NULL());
        }
        this.addValueList(index, (JsonValue)builder.build());
        return this;
    }

    public JsonArrayBuilder set(int index, JsonValue value) {
        this.validateValue(value);
        this.setValueList(index, value);
        return this;
    }

    public JsonArrayBuilder set(int index, String value) {
        this.validateValue(value);
        this.setValueList(index, (JsonValue)new JsonStringImpl(value));
        return this;
    }

    public JsonArrayBuilder set(int index, BigDecimal value) {
        this.validateValue(value);
        this.setValueList(index, (JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder set(int index, BigInteger value) {
        this.validateValue(value);
        this.setValueList(index, (JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder set(int index, int value) {
        this.setValueList(index, (JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder set(int index, long value) {
        this.setValueList(index, (JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder set(int index, double value) {
        this.setValueList(index, (JsonValue)JsonNumberImpl.getJsonNumber(value, this.jsonContext.bigIntegerScaleLimit()));
        return this;
    }

    public JsonArrayBuilder set(int index, boolean value) {
        this.setValueList(index, value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    public JsonArrayBuilder setNull(int index) {
        this.setValueList(index, JsonValue.NULL);
        return this;
    }

    public JsonArrayBuilder set(int index, JsonObjectBuilder builder) {
        if (builder == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_OBJECT_BUILDER_NULL());
        }
        this.setValueList(index, (JsonValue)builder.build());
        return this;
    }

    public JsonArrayBuilder set(int index, JsonArrayBuilder builder) {
        if (builder == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_OBJECT_BUILDER_NULL());
        }
        this.setValueList(index, (JsonValue)builder.build());
        return this;
    }

    public JsonArrayBuilder remove(int index) {
        if (this.valueList == null) {
            throw new IndexOutOfBoundsException(JsonMessages.ARRBUILDER_VALUELIST_NULL(index, 0));
        }
        this.valueList.remove(index);
        return this;
    }

    public JsonArray build() {
        List<Object> snapshot = this.valueList == null ? Collections.emptyList() : Collections.unmodifiableList(this.valueList);
        this.valueList = null;
        return new JsonArrayImpl(snapshot, this.jsonContext);
    }

    private void populate(Collection<?> collection) {
        for (Object value : collection) {
            if (value instanceof Optional) {
                ((Optional)value).ifPresent(v -> this.valueList.add(MapUtil.handle(v, this.jsonContext)));
                continue;
            }
            this.valueList.add(MapUtil.handle(value, this.jsonContext));
        }
    }

    private void addValueList(JsonValue value) {
        if (this.valueList == null) {
            this.valueList = new ArrayList();
        }
        this.valueList.add(value);
    }

    private void addValueList(int index, JsonValue value) {
        if (this.valueList == null) {
            this.valueList = new ArrayList();
        }
        this.valueList.add(index, value);
    }

    private void setValueList(int index, JsonValue value) {
        if (this.valueList == null) {
            throw new IndexOutOfBoundsException(JsonMessages.ARRBUILDER_VALUELIST_NULL(index, 0));
        }
        this.valueList.set(index, value);
    }

    private void validateValue(Object value) {
        if (value == null) {
            throw new NullPointerException(JsonMessages.ARRBUILDER_VALUE_NULL());
        }
    }

    private static final class JsonArrayImpl
    extends AbstractList<JsonValue>
    implements JsonArray {
        private final List<JsonValue> valueList;
        private final JsonContext jsonContext;
        private int hashCode;

        JsonArrayImpl(List<JsonValue> valueList, JsonContext jsonContext) {
            this.valueList = valueList;
            this.jsonContext = jsonContext;
        }

        @Override
        public int size() {
            return this.valueList.size();
        }

        public JsonObject getJsonObject(int index) {
            return (JsonObject)this.valueList.get(index);
        }

        public JsonArray getJsonArray(int index) {
            return (JsonArray)this.valueList.get(index);
        }

        public JsonNumber getJsonNumber(int index) {
            return (JsonNumber)this.valueList.get(index);
        }

        public JsonString getJsonString(int index) {
            return (JsonString)this.valueList.get(index);
        }

        public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
            return this.valueList;
        }

        public String getString(int index) {
            return this.getJsonString(index).getString();
        }

        public String getString(int index, String defaultValue) {
            try {
                return this.getString(index);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public int getInt(int index) {
            return this.getJsonNumber(index).intValue();
        }

        public int getInt(int index, int defaultValue) {
            try {
                return this.getInt(index);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public boolean getBoolean(int index) {
            JsonValue jsonValue = this.get(index);
            if (jsonValue == JsonValue.TRUE) {
                return true;
            }
            if (jsonValue == JsonValue.FALSE) {
                return false;
            }
            throw new ClassCastException();
        }

        public boolean getBoolean(int index, boolean defaultValue) {
            try {
                return this.getBoolean(index);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public boolean isNull(int index) {
            return this.valueList.get(index).equals(JsonValue.NULL);
        }

        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.ARRAY;
        }

        @Override
        public JsonValue get(int index) {
            return this.valueList.get(index);
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = super.hashCode();
            }
            return this.hashCode;
        }

        @Override
        public String toString() {
            StringWriter sw = new StringWriter();
            try (JsonWriterImpl jw = new JsonWriterImpl(sw, this.jsonContext);){
                jw.write((JsonStructure)this);
            }
            return sw.toString();
        }

        public JsonArray asJsonArray() {
            return this;
        }
    }
}

