/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import java.util.concurrent.ExecutorService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.service.http.netty.impl.server.ForwardingToListenerHandler;
import org.mule.service.http.netty.impl.server.ForwardingToListenerInitializer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.test.netty.tck.ExecutorRule;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ForwardingToListenerInitializerTestCase
extends AbstractMuleTestCase {
    @ClassRule
    public static ExecutorRule executorRule = new ExecutorRule();
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock
    private HttpListenerRegistry httpListenerRegistry;
    @Mock
    private SslHandler sslHandler;
    @Mock
    private Channel channel;
    @Mock
    private ChannelPipeline pipeline;
    private ForwardingToListenerInitializer initializer;

    @Before
    public void setUp() {
        Mockito.when((Object)this.channel.pipeline()).thenReturn((Object)this.pipeline);
        this.initializer = new ForwardingToListenerInitializer(this.httpListenerRegistry, this.sslHandler, (ExecutorService)executorRule.getExecutor());
    }

    @Test
    public void initializeChannelAddsTheCorrectHandlerAndPassesTheSslHandler() {
        this.initializer.initChannel(this.channel);
        ArgumentCaptor handlerCaptor = ArgumentCaptor.forClass(ForwardingToListenerHandler.class);
        ((ChannelPipeline)Mockito.verify((Object)this.pipeline)).addLast((String)ArgumentMatchers.eq((Object)"Forward to HTTP Listener"), (ChannelHandler)handlerCaptor.capture());
        ForwardingToListenerHandler handler = (ForwardingToListenerHandler)handlerCaptor.getValue();
        MatcherAssert.assertThat((Object)handler.getSslHandler(), (Matcher)Matchers.is((Object)this.sslHandler));
    }
}

