/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.ssl.SslContext;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.RoundRobinDnsAddressResolverGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.sse.client.SseSource;
import org.mule.runtime.http.api.sse.client.SseSourceConfig;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.service.http.common.client.sse.DefaultSseSource;
import org.mule.service.http.common.client.sse.InternalClient;
import org.mule.service.http.common.client.sse.NoOpProgressiveBodyDataListener;
import org.mule.service.http.common.client.sse.ProgressiveBodyDataListener;
import org.mule.service.http.netty.impl.client.ClientExpectContinueHandler;
import org.mule.service.http.netty.impl.client.HttpClientHandler;
import org.mule.service.http.netty.impl.client.InetNoopAddressResolverGroup;
import org.mule.service.http.netty.impl.client.ReactorNettyClient;
import org.mule.service.http.netty.impl.client.RedirectMethodChangeHandler;
import org.mule.service.http.netty.impl.client.RemoveContentLengthHandler;
import org.mule.service.http.netty.impl.client.WebSocketsProvider;
import org.mule.service.http.netty.impl.client.auth.AuthenticationEngine;
import org.mule.service.http.netty.impl.client.auth.AuthenticationHandler;
import org.mule.service.http.netty.impl.client.proxy.ProxyPipelineConfigurer;
import org.mule.service.http.netty.impl.util.HttpLoggingHandler;
import org.mule.service.http.netty.impl.util.MuleToNettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.SslProvider;

public class NettyHttpClient
implements org.mule.runtime.http.api.client.HttpClient,
InternalClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyHttpClient.class);
    private static final int DEFAULT_SELECTORS_COUNT = Math.min(Runtime.getRuntime().availableProcessors(), 2);
    private static final int CLIENT_DNS_EVENT_LOOP_COUNT = Math.min(Runtime.getRuntime().availableProcessors(), 2);
    private static final int MAX_CONNECTIONS_UNLIMITED = Integer.MAX_VALUE;
    private static final long EVICT_IN_BACKGROUND_AFTER = 10L;
    private final AtomicInteger totalConnections = new AtomicInteger();
    private SslContext sslContext;
    private int connectionIdleTimeout;
    private boolean usePersistentConnections;
    private HttpClient noProxyHttpClient;
    private ReactorNettyClient reactorNettyClient;
    private WebSocketsProvider webSocketsProvider = new WebSocketsProvider(){};
    private int maxConnections;
    private int selectorsCount = DEFAULT_SELECTORS_COUNT;
    private Supplier<Scheduler> selectorsSchedulerSupplier = () -> null;
    private Scheduler selectorsScheduler;
    private int dnsEventLoopCount = CLIENT_DNS_EVENT_LOOP_COUNT;
    private ScheduledExecutorService ioTasksScheduler;
    private ProxyConfig proxyConfig;
    private static final int MAX_NUM_HEADERS_DEFAULT = 100;
    private static final String MAX_CLIENT_REQUEST_HEADERS_KEY = "mule.http.MAX_CLIENT_REQUEST_HEADERS";
    private static int MAX_CLIENT_REQUEST_HEADERS = Integer.getInteger("mule.http.MAX_CLIENT_REQUEST_HEADERS", 100);
    private EventLoopGroup selectorsGroup;
    private EventLoopGroup dnsEventLoopGroup;
    private AddressResolverGroup<InetSocketAddress> resolverGroup;
    private boolean responseStreamingEnabled = false;
    private String name;

    private NettyHttpClient() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public void start() {
        int resultingMaxConnections = this.maxConnections > 0 ? this.maxConnections : Integer.MAX_VALUE;
        ConnectionProvider.Builder connectionProviderBuilder = (ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"CustomConnectionProvider").maxConnections(resultingMaxConnections)).maxIdleTime(Duration.ofMillis(this.connectionIdleTimeout))).evictInBackground(Duration.ofMillis(this.connectionIdleTimeout > 0 ? 10L : 0L));
        this.selectorsScheduler = this.selectorsSchedulerSupplier.get();
        this.selectorsGroup = Epoll.isAvailable() ? new EpollEventLoopGroup(this.selectorsCount, (Executor)this.selectorsScheduler) : new NioEventLoopGroup(this.selectorsCount, (Executor)this.selectorsScheduler);
        this.resolverGroup = this.initializeResolverGroup();
        HttpClient httpClient = (HttpClient)((HttpClient)((HttpClient)((HttpClient)((HttpClient)((HttpClient)HttpClient.create((ConnectionProvider)connectionProviderBuilder.build()).runOn(this.selectorsGroup)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectionIdleTimeout)).doOnConnect(config -> {
            if (this.totalConnections.get() + 1 > resultingMaxConnections) {
                throw new RuntimeException("Connection limit exceeded, cannot process request");
            }
        })).doOnConnected(connection -> this.totalConnections.incrementAndGet())).doOnChannelInit((observer, channel, remoteAddress) -> {
            channel.pipeline().addBefore("reactor.left.httpCodec", "HttpLogging", (ChannelHandler)new HttpLoggingHandler());
            channel.pipeline().addAfter("reactor.left.httpCodec", "removeContentLengthHandler", (ChannelHandler)new RemoveContentLengthHandler());
            channel.pipeline().addAfter("reactor.left.httpCodec", "100ContinueClientHandler", (ChannelHandler)new ClientExpectContinueHandler(this.ioTasksScheduler));
            channel.pipeline().addAfter("reactor.left.httpCodec", "RedirectMethodChangeHandler", (ChannelHandler)new RedirectMethodChangeHandler());
            channel.pipeline().addLast(new ChannelHandler[]{new HttpClientHandler(this.usePersistentConnections)});
        })).followRedirect(true).resolver(this.resolverGroup);
        if (this.sslContext != null) {
            httpClient = httpClient.secure(SslProvider.builder().sslContext(this.sslContext).build());
        }
        this.noProxyHttpClient = httpClient;
        this.reactorNettyClient = new ReactorNettyClient(this.name, this.configureProxy(this.proxyConfig), this.ioTasksScheduler);
    }

    private HttpClient configureProxy(ProxyConfig proxyCfg) {
        return (HttpClient)this.noProxyHttpClient.doOnChannelInit((observer, channel, remoteAddress) -> {
            boolean useTunnelingProxy = this.sslContext != null;
            new ProxyPipelineConfigurer(proxyCfg).configurePipeline(channel.pipeline(), remoteAddress, useTunnelingProxy);
        });
    }

    private AddressResolverGroup<InetSocketAddress> initializeResolverGroup() {
        if (this.proxyConfig == null || this.sslContext == null) {
            LOGGER.debug("Initializing DNS resolver for direct connections");
            this.dnsEventLoopGroup = Epoll.isAvailable() ? new EpollEventLoopGroup(this.dnsEventLoopCount, (Executor)this.ioTasksScheduler) : new NioEventLoopGroup(this.dnsEventLoopCount, (Executor)this.ioTasksScheduler);
            DnsNameResolverBuilder dnsNameResolverBuilder = new DnsNameResolverBuilder(this.dnsEventLoopGroup.next()).datagramChannelType(Epoll.isAvailable() ? EpollDatagramChannel.class : NioDatagramChannel.class).optResourceEnabled(true).resolveCache((DnsCache)new DefaultDnsCache());
            return new RoundRobinDnsAddressResolverGroup(dnsNameResolverBuilder);
        }
        LOGGER.debug("Proxy is configured with SSL, so the DNS resolution should be done by the proxy. Using NOOP resolver");
        return InetNoopAddressResolverGroup.INSTANCE;
    }

    public AddressResolverGroup<InetSocketAddress> getResolverGroup() {
        return this.resolverGroup;
    }

    public void stop() {
        if (this.selectorsGroup != null) {
            this.selectorsGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).syncUninterruptibly();
            this.selectorsGroup = null;
        }
        if (this.selectorsScheduler != null) {
            this.selectorsScheduler.stop();
            this.selectorsScheduler = null;
        }
        if (this.dnsEventLoopGroup != null) {
            this.dnsEventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).syncUninterruptibly();
            this.dnsEventLoopGroup = null;
        }
        this.resolverGroup = null;
    }

    public HttpResponse send(HttpRequest request, HttpRequestOptions options) throws IOException {
        try {
            return this.sendAsync(request, options).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }

    public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, HttpRequestOptions options) {
        try {
            return this.doSendAsync(request, options, new NoOpProgressiveBodyDataListener());
        }
        catch (Throwable t) {
            CompletableFuture<HttpResponse> errorFuture = new CompletableFuture<HttpResponse>();
            errorFuture.completeExceptionally(t);
            return errorFuture;
        }
    }

    public SseSource sseSource(SseSourceConfig config) {
        if (!this.responseStreamingEnabled) {
            throw new IllegalStateException("SSE source requires streaming enabled for client '%s'".formatted(this.name));
        }
        return new DefaultSseSource(config, this, this.ioTasksScheduler);
    }

    public CompletableFuture<WebSocket> openWebSocket(HttpRequest request, String socketId, WebSocketCallback callback) {
        return this.webSocketsProvider.openWebSocket(request, socketId, callback, this.sslContext);
    }

    public CompletableFuture<WebSocket> openWebSocket(HttpRequest request, HttpRequestOptions requestOptions, String socketId, WebSocketCallback callback) {
        return this.webSocketsProvider.openWebSocket(request, requestOptions, socketId, callback, this.sslContext);
    }

    @Override
    public CompletableFuture<HttpResponse> doSendAsync(HttpRequest request, HttpRequestOptions options, ProgressiveBodyDataListener dataListener) {
        ReactorNettyClient reactorNettyClient = options.getProxyConfig().map(proxyCfg -> new ReactorNettyClient(this.name, this.configureProxy((ProxyConfig)proxyCfg), this.ioTasksScheduler)).orElse(this.reactorNettyClient);
        Optional authentication = options.getAuthentication();
        AuthenticationEngine authHeadersProvider = authentication.map(httpAuthentication -> new AuthenticationEngine((HttpAuthentication)httpAuthentication, request.getUri(), request.getMethod())).orElse(null);
        reactorNettyClient.prepareContentForRepeatability(request.getEntity());
        CompletableFuture<HttpResponse> result = new CompletableFuture<HttpResponse>();
        HttpHeaders headers = this.constructHeaders(options, request, authHeadersProvider);
        reactorNettyClient.sendAsyncRequest(request, options, headers, (response, content) -> {
            reactorNettyClient.rewindStreamContent(request.getEntity());
            AuthenticationHandler authenticationHandler = new AuthenticationHandler(reactorNettyClient, authHeadersProvider);
            if (authentication.isPresent() && authenticationHandler.needsAuth((HttpClientResponse)response, options)) {
                return authenticationHandler.doHandle(request, options, (HttpClientResponse)response, result, dataListener);
            }
            return reactorNettyClient.receiveContent((HttpClientResponse)response, (ByteBufFlux)content, result, dataListener);
        }, result).subscribe();
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private HttpHeaders constructHeaders(HttpRequestOptions options, HttpRequest request, AuthenticationEngine authEngine) {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        MuleToNettyUtils.addAllRequestHeaders(request, (HttpHeaders)headers, request.getUri());
        NettyHttpClient.checkMaxRequestHeadersLimit((HttpHeaders)headers);
        if (options.getAuthentication().isPresent()) {
            headers.add(authEngine.getAuthHeaders((HttpHeaders)headers));
        }
        return headers;
    }

    private static void checkMaxRequestHeadersLimit(HttpHeaders headers) {
        if (headers.size() > MAX_CLIENT_REQUEST_HEADERS) {
            LOGGER.warn("Exceeded max client request headers limit: {}. Current header count (including default headers): {}", (Object)MAX_CLIENT_REQUEST_HEADERS, (Object)headers.entries().size());
            throw new IllegalArgumentException("Exceeded max client request headers limit: " + MAX_CLIENT_REQUEST_HEADERS);
        }
    }

    public static void refreshMaxClientRequestHeaders() {
        MAX_CLIENT_REQUEST_HEADERS = Integer.getInteger(MAX_CLIENT_REQUEST_HEADERS_KEY, 100);
    }

    public static int getMaxClientRequestHeaders() {
        return MAX_CLIENT_REQUEST_HEADERS;
    }

    public static class Builder {
        private final NettyHttpClient product = new NettyHttpClient();

        private Builder() {
        }

        public NettyHttpClient build() {
            return this.product;
        }

        public Builder withName(String name) {
            this.product.name = name;
            return this;
        }

        public Builder withSslContext(SslContext sslContext) {
            this.product.sslContext = sslContext;
            return this;
        }

        public Builder withConnectionIdleTimeout(int connectionIdleTimeout) {
            this.product.connectionIdleTimeout = connectionIdleTimeout;
            return this;
        }

        public Builder withUsingPersistentConnections(boolean usePersistentConnections) {
            this.product.usePersistentConnections = usePersistentConnections;
            return this;
        }

        public Builder withMaxConnections(int maxConnections) {
            int resultingMaxConnections;
            this.product.maxConnections = resultingMaxConnections = maxConnections > 0 ? maxConnections : Integer.MAX_VALUE;
            return this;
        }

        public Builder withWebSocketsProvider(WebSocketsProvider webSocketsProvider) {
            this.product.webSocketsProvider = webSocketsProvider;
            return this;
        }

        public Builder withSelectorsScheduler(Supplier<Scheduler> selectorsScheduler) {
            this.product.selectorsSchedulerSupplier = selectorsScheduler;
            return this;
        }

        public Builder withSelectorsCount(int selectorsCount) {
            this.product.selectorsCount = selectorsCount;
            return this;
        }

        public Builder withProxyConfig(ProxyConfig proxyConfig) {
            this.product.proxyConfig = proxyConfig;
            return this;
        }

        public Builder withIOTasksScheduler(ScheduledExecutorService ioTasksScheduler) {
            this.product.ioTasksScheduler = ioTasksScheduler;
            return this;
        }

        public Builder withDnsEventLoopCount(int dnsEventLoopCount) {
            this.product.dnsEventLoopCount = dnsEventLoopCount;
            return this;
        }

        public Builder withResponseStreamingEnabled(boolean responseStreamingEnabled) {
            this.product.responseStreamingEnabled = responseStreamingEnabled;
            return this;
        }
    }
}

