/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import java.io.Closeable;
import java.util.Map;
import org.glassfish.grizzly.CompletionHandler;
import org.slf4j.MDC;

public class PreservingThreadContextCompletionHandler<E>
implements CompletionHandler<E> {
    private final CompletionHandler<E> delegate;
    private final ClassLoader classLoader;
    private final Map<String, String> mdc;

    public PreservingThreadContextCompletionHandler(CompletionHandler<E> delegate) {
        this.delegate = delegate;
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.mdc = MDC.getCopyOfContextMap();
    }

    public void cancelled() {
        try (ThreadContext tc = new ThreadContext(this.classLoader, this.mdc);){
            this.delegate.cancelled();
        }
    }

    public void failed(Throwable throwable) {
        try (ThreadContext tc = new ThreadContext(this.classLoader, this.mdc);){
            this.delegate.failed(throwable);
        }
    }

    public void completed(E e) {
        try (ThreadContext tc = new ThreadContext(this.classLoader, this.mdc);){
            this.delegate.completed(e);
        }
    }

    public void updated(E e) {
        try (ThreadContext tc = new ThreadContext(this.classLoader, this.mdc);){
            this.delegate.updated(e);
        }
    }

    private static class ThreadContext
    implements Closeable {
        private final Thread currentThread = Thread.currentThread();
        private final ClassLoader innerClassLoader;
        private final Map<String, String> innerMDC;
        private final ClassLoader outerClassLoader;
        private final Map<String, String> outerMDC;

        ThreadContext(ClassLoader classLoader, Map<String, String> mdc) {
            this.innerClassLoader = classLoader;
            this.innerMDC = mdc;
            this.outerClassLoader = this.currentThread.getContextClassLoader();
            this.outerMDC = MDC.getCopyOfContextMap();
            if (this.innerMDC != null) {
                MDC.setContextMap(this.innerMDC);
            }
            this.setContextClassLoader(this.currentThread, this.outerClassLoader, this.innerClassLoader);
        }

        private void setContextClassLoader(Thread thread, ClassLoader currentClassLoader, ClassLoader newClassLoader) {
            if (currentClassLoader != newClassLoader) {
                thread.setContextClassLoader(newClassLoader);
            }
        }

        @Override
        public void close() {
            try {
                this.setContextClassLoader(this.currentThread, this.innerClassLoader, this.outerClassLoader);
            }
            finally {
                if (this.innerMDC != null && this.outerMDC != null) {
                    MDC.setContextMap(this.outerMDC);
                }
            }
        }
    }
}

