/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.matcher.ElementMatcher;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@HashCodeAndEqualsPlugin.Enhance
public class CollectionOneToOneMatcher<T>
extends ElementMatcher.Junction.ForNonNullValues<Iterable<? extends T>> {
    private final List<? extends ElementMatcher<? super T>> matchers;

    public CollectionOneToOneMatcher(List<? extends ElementMatcher<? super T>> matchers) {
        this.matchers = matchers;
    }

    @Override
    protected boolean doMatch(Iterable<? extends T> target) {
        if (target instanceof Collection && ((Collection)target).size() != this.matchers.size()) {
            return false;
        }
        Iterator<ElementMatcher<T>> iterator = this.matchers.iterator();
        for (T value : target) {
            if (iterator.hasNext() && iterator.next().matches(value)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("containing(");
        boolean first = true;
        for (ElementMatcher<? super T> elementMatcher : this.matchers) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(elementMatcher);
        }
        return stringBuilder.append(')').toString();
    }
}

