/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.auth.ntlm.message;

import java.io.IOException;
import org.mule.service.http.netty.impl.client.auth.ntlm.message.NtlmMessage;

public class Type2Message
extends NtlmMessage {
    private byte[] targetInformation;
    private byte[] challenge;
    private byte[] context;
    private String target;

    public Type2Message(byte[] material) throws IOException {
        this.parse(material);
    }

    private void parse(byte[] input) throws IOException {
        int pos = 0;
        for (int i = 0; i < 8; ++i) {
            if (input[i] == NTLMSSP_SIGNATURE[i]) continue;
            throw new IOException("Not an NTLMSSP message.");
        }
        if (Type2Message.readULong(input, pos += 8) != 2) {
            throw new IOException("Not a Type 2 message.");
        }
        int flags = Type2Message.readULong(input, (pos += 4) + 8);
        this.setFlags(flags);
        byte[] targetName = Type2Message.readSecurityBuffer(input, pos);
        int targetNameOff = Type2Message.readULong(input, pos + 4);
        if (targetName.length != 0) {
            this.setTarget(new String(targetName, (flags & 1) != 0 ? "UTF-16LE" : Type2Message.getOEMEncoding()));
        }
        if (!Type2Message.allZeros8(input, pos += 12)) {
            byte[] challengeBytes = new byte[8];
            System.arraycopy(input, pos, challengeBytes, 0, challengeBytes.length);
            this.setChallenge(challengeBytes);
        }
        if (targetNameOff < (pos += 8) + 8 || input.length < pos + 8) {
            return;
        }
        if (!Type2Message.allZeros8(input, pos)) {
            byte[] contextBytes = new byte[8];
            System.arraycopy(input, pos, contextBytes, 0, contextBytes.length);
            this.setContext(contextBytes);
        }
        if (targetNameOff < (pos += 8) + 8 || input.length < pos + 8) {
            return;
        }
        byte[] targetInfo = Type2Message.readSecurityBuffer(input, pos);
        if (targetInfo.length != 0) {
            this.setTargetInformation(targetInfo);
        }
    }

    public void setChallenge(byte[] challenge) {
        this.challenge = challenge;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTargetInformation(byte[] targetInformation) {
        this.targetInformation = targetInformation;
    }

    private static boolean allZeros8(byte[] input, int pos) {
        for (int i = pos; i < pos + 8; ++i) {
            if (input[i] == 0) continue;
            return false;
        }
        return true;
    }

    public void setContext(byte[] context) {
        this.context = context;
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public byte[] getTargetInformation() {
        return this.targetInformation;
    }

    public byte[] getContext() {
        return this.context;
    }

    public String getTarget() {
        return this.target;
    }
}

