/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.serializer;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Stack;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.serializer.AbstractComplexTypeSerializer;
import org.mule.metadata.persistence.serializer.TypeSerializer;

public class FunctionTypeSerializer
extends AbstractComplexTypeSerializer<FunctionType> {
    private final TypeSerializer<MetadataType> delegate;

    FunctionTypeSerializer(TypeSerializer<MetadataType> delegate) {
        super("Function");
        this.delegate = delegate;
    }

    @Override
    public void doSerialize(JsonWriter writer, FunctionType functionType, Stack<MetadataType> typeStack) throws IOException {
        List parameters = functionType.getParameters();
        writer.name("parameters");
        writer.beginArray();
        for (FunctionParameter parameter : parameters) {
            writer.beginObject();
            writer.name("name").value(parameter.getName());
            if (parameter.isOptional()) {
                writer.name("required").value(!parameter.isOptional());
            }
            writer.name("type");
            this.delegate.serialize(writer, parameter.getType(), typeStack);
            writer.endObject();
        }
        writer.endArray();
        functionType.getReturnType().ifPresent(returnType -> {
            try {
                writer.name("returnType");
                this.delegate.serialize(writer, (MetadataType)returnType, typeStack);
            }
            catch (IOException e) {
                throw new MetadataSerializingException("the returnType field for FunctionType", e);
            }
        });
    }
}

