/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation.construct;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.execution.ExecutionResult;
import org.mule.runtime.api.component.execution.InputEvent;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.module.extension.internal.runtime.operation.construct.DefaultOperationBuilder;
import org.mule.runtime.module.extension.internal.runtime.operation.construct.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleOperation
extends AbstractComponent
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleOperation.class);
    private final List<Processor> processors;
    private final OperationModel operationModel;
    private final MuleContext muleContext;
    private MessageProcessorChain chain;
    private ProcessingStrategy processingStrategy;

    public static Operation.Builder builder() {
        return new DefaultOperationBuilder();
    }

    MuleOperation(List<Processor> processors, OperationModel operationModel, MuleContext muleContext) {
        this.processors = processors;
        this.operationModel = operationModel;
        this.muleContext = muleContext;
    }

    public CompletableFuture<ExecutionResult> execute(InputEvent inputEvent) {
        return this.chain.execute(inputEvent);
    }

    public CompletableFuture<Event> execute(Event event) {
        return this.chain.execute(event);
    }

    public void initialise() throws InitialisationException {
        this.processingStrategy = MessageProcessors.getDefaultProcessingStrategyFactory((MuleContext)this.muleContext).create(this.muleContext, this.operationModel.getName());
        LifecycleUtils.initialiseIfNeeded((Object)this.processingStrategy);
        this.chain = MessageProcessors.newChain(Optional.ofNullable(this.processingStrategy), this.processors);
        LifecycleUtils.initialiseIfNeeded((Object)this.chain, (boolean)true, (MuleContext)this.muleContext);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.processingStrategy);
        LifecycleUtils.startIfNeeded((Object)this.chain);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.chain);
        LifecycleUtils.stopIfNeeded((Object)this.processingStrategy);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.chain, (Logger)LOGGER);
        LifecycleUtils.disposeIfNeeded((Object)this.processingStrategy, (Logger)LOGGER);
    }

    @Override
    public OperationModel getModel() {
        return this.operationModel;
    }
}

