/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.span.command;

import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.api.profiling.tracing.SpanIdentifier;
import org.slf4j.MDC;

public class SpanMDCUtils {
    public static final String SPAN_ID_MDC_KEY = "span-id";
    public static final String TRACE_ID_MDC_KEY = "trace-id";

    private SpanMDCUtils() {
    }

    public static void setCurrentTracingInformationToMdc(Span span) {
        SpanIdentifier spanIdentifier = span.getIdentifier();
        if (spanIdentifier != null && spanIdentifier.isValid()) {
            MDC.put((String)SPAN_ID_MDC_KEY, (String)spanIdentifier.getId());
            MDC.put((String)TRACE_ID_MDC_KEY, (String)spanIdentifier.getTraceId());
        }
    }

    public static void removeCurrentTracingInformationFromMdc() {
        MDC.remove((String)SPAN_ID_MDC_KEY);
        MDC.remove((String)TRACE_ID_MDC_KEY);
    }
}

