/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.MessageProvider;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.keyword.validator.helpers.DraftV3TypeKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.Iterator;

public final class DisallowKeywordValidator
extends DraftV3TypeKeywordValidator {
    public DisallowKeywordValidator(JsonNode digested) {
        super("disallow", digested);
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        NodeType type = NodeType.getNodeType((JsonNode)instance);
        if (this.types.contains(type)) {
            report.error(this.newMsg(data, bundle, "err.draftv3.disallow.type").putArgument("found", (Object)type).putArgument("disallowed", DisallowKeywordValidator.toArrayNode(this.types)));
            return;
        }
        SchemaTree tree = data.getSchema();
        JsonPointer schemaPointer = tree.getPointer();
        ObjectNode fullReport = FACTORY.objectNode();
        int nrSuccess = 0;
        Iterator iterator = this.schemas.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
            JsonPointer ptr = schemaPointer.append(JsonPointer.of((Object)this.keyword, (Object[])new Object[]{index}));
            FullData newData = data.withSchema(tree.setPointer(ptr));
            processor.process((ProcessingReport)subReport, (MessageProvider)newData);
            fullReport.put(ptr.toString(), subReport.asJson());
            if (!subReport.isSuccess()) continue;
            ++nrSuccess;
        }
        if (nrSuccess != 0) {
            report.error(this.newMsg(data, bundle, "err.draftv3.disallow.schema").putArgument("matched", nrSuccess).putArgument("nrSchemas", this.schemas.size()).put("reports", (JsonNode)fullReport));
        }
    }
}

