/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.DispatchException;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.management.stats.ServiceStatistics;
import org.mule.transport.DefaultReplyToHandler;
import org.mule.transport.jms.Jms102bSupport;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsMessageUtils;
import org.mule.transport.jms.i18n.JmsMessages;
import org.mule.transport.jms.transformers.ObjectToJMSMessage;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;

public class JmsReplyToHandler
extends DefaultReplyToHandler {
    private static final long serialVersionUID = 1L;
    private transient JmsConnector jmsConnector;
    private transient ObjectToJMSMessage toJmsMessage;

    public JmsReplyToHandler(JmsConnector connector, MuleContext muleContext) {
        super(muleContext);
        this.jmsConnector = connector;
        this.connector = this.jmsConnector;
        this.toJmsMessage = new ObjectToJMSMessage();
    }

    public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
        Destination replyToDestination = null;
        MessageProducer replyToProducer = null;
        Session session = null;
        try {
            ServiceStatistics stats;
            if (replyTo instanceof Destination) {
                replyToDestination = (Destination)replyTo;
            }
            if (replyToDestination == null) {
                super.processReplyTo(event, returnMessage, replyTo);
                return;
            }
            Class<?> srcType = returnMessage.getPayload().getClass();
            EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(String.format("%s://temporary", this.connector.getProtocol()), this.muleContext);
            endpointBuilder.setConnector((Connector)this.jmsConnector);
            OutboundEndpoint tempEndpoint = this.muleContext.getEndpointFactory().getOutboundEndpoint((EndpointBuilder)endpointBuilder);
            List defaultTransportTransformers = this.jmsConnector.getDefaultOutboundTransformers((ImmutableEndpoint)tempEndpoint);
            returnMessage.applyTransformers(event, defaultTransportTransformers);
            Object payload = returnMessage.getPayload();
            if (replyToDestination instanceof Topic && replyToDestination instanceof Queue && this.jmsConnector.getJmsSupport() instanceof Jms102bSupport) {
                this.logger.error((Object)StringMessageUtils.getBoilerPlate((String)"ReplyTo destination implements both Queue and Topic while complying with JMS 1.0.2b specification. Please report your application server or JMS vendor name and version to dev<_at_>mule.codehaus.org or http://mule.mulesoft.org/jira"));
            }
            boolean topic = this.jmsConnector.getTopicResolver().isTopic(replyToDestination);
            session = this.jmsConnector.getSession(false, topic);
            Message replyToMessage = JmsMessageUtils.toMessage(payload, session);
            this.connector.getSessionHandler().storeSessionInfoToMessage(event.getSession(), returnMessage);
            this.toJmsMessage.setJmsProperties(returnMessage, replyToMessage);
            this.processMessage(replyToMessage, event);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Sending jms reply to: " + replyToDestination + " (" + replyToDestination.getClass().getName() + ")"));
            }
            replyToProducer = this.jmsConnector.getJmsSupport().createProducer(session, replyToDestination, topic);
            MuleMessage eventMsg = event.getMessage();
            String ttlString = (String)eventMsg.getOutboundProperty("timeToLive");
            String priorityString = (String)eventMsg.getOutboundProperty("priority");
            String persistentDeliveryString = (String)eventMsg.getOutboundProperty("persistentDelivery");
            String correlationIDString = replyToMessage.getJMSCorrelationID();
            if (StringUtils.isBlank((String)correlationIDString)) {
                correlationIDString = (String)eventMsg.getInboundProperty("JMSMessageID");
                replyToMessage.setJMSCorrelationID(correlationIDString);
            }
            if (event.getFlowConstruct() instanceof Service && (stats = ((Service)event.getFlowConstruct()).getStatistics()).isEnabled()) {
                stats.incSentReplyToEvent();
            }
            if (ttlString == null && priorityString == null && persistentDeliveryString == null) {
                this.jmsConnector.getJmsSupport().send(replyToProducer, replyToMessage, topic, null);
            } else {
                long ttl = 0L;
                int priority = 4;
                if (ttlString != null) {
                    ttl = Long.parseLong(ttlString);
                }
                if (priorityString != null) {
                    priority = Integer.parseInt(priorityString);
                }
                boolean persistent = StringUtils.isNotBlank((String)persistentDeliveryString) ? Boolean.valueOf(persistentDeliveryString).booleanValue() : this.jmsConnector.isPersistentDelivery();
                this.jmsConnector.getJmsSupport().send(replyToProducer, replyToMessage, persistent, priority, ttl, topic, null);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("Reply Message sent to: %s with correlationID:%s", replyToDestination, correlationIDString));
            }
            this.jmsConnector.closeQuietly(replyToProducer);
            this.jmsConnector.closeSessionIfNoTransactionActive(session);
        }
        catch (Exception e) {
            throw new DispatchException(JmsMessages.failedToCreateAndDispatchResponse(replyToDestination), event, null, (Throwable)e);
        }
        finally {
            this.jmsConnector.closeQuietly(replyToProducer);
            this.jmsConnector.closeSessionIfNoTransactionActive(session);
        }
    }

    protected void processMessage(Message replyToMessage, MuleEvent event) throws JMSException {
        replyToMessage.setJMSReplyTo(null);
        MuleMessage eventMsg = event.getMessage();
        String jmsCorrelationId = (String)eventMsg.getInboundProperty("JMSCorrelationID");
        if (jmsCorrelationId == null) {
            jmsCorrelationId = (String)eventMsg.getInboundProperty("JMSMessageID");
        }
        if (jmsCorrelationId != null) {
            replyToMessage.setJMSCorrelationID(jmsCorrelationId);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("replyTo message is " + replyToMessage));
        }
    }

    public void initAfterDeserialisation(MuleContext muleContext) throws MuleException {
        super.initAfterDeserialisation(muleContext);
        this.toJmsMessage = new ObjectToJMSMessage();
        this.jmsConnector = (JmsConnector)this.connector;
    }
}

