/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.Foreach;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestMessageProcessor;

public class ForeachTestCase
extends AbstractMuleContextTestCase {
    protected Foreach simpleForeach;
    protected Foreach nestedForeach;
    protected ArrayList<MuleEvent> processedEvents;
    private static String ERR_NUMBER_MESSAGES = "Not a correct number of messages processed";
    private static String ERR_PAYLOAD_TYPE = "Type error on processed payloads";
    private static String ERR_OUTPUT = "Messages processed incorrectly";

    @Before
    public void initialise() throws MuleException {
        this.processedEvents = new ArrayList();
        this.simpleForeach = this.createForeach(this.getSimpleMessageProcessors());
        this.nestedForeach = this.createForeach(this.getNestedMessageProcessors());
    }

    private List<MessageProcessor> getSimpleMessageProcessors() {
        ArrayList<MessageProcessor> lmp = new ArrayList<MessageProcessor>();
        lmp.add(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) {
                String payload = event.getMessage().getPayload().toString();
                event.getMessage().setPayload((Object)(payload + ":foo"));
                ForeachTestCase.this.processedEvents.add(event);
                return event;
            }
        });
        lmp.add(new TestMessageProcessor("zas"));
        return lmp;
    }

    private List<MessageProcessor> getNestedMessageProcessors() throws MuleException {
        ArrayList<MessageProcessor> lmp = new ArrayList<MessageProcessor>();
        Foreach internalForeach = new Foreach();
        internalForeach.setMessageProcessors(this.getSimpleMessageProcessors());
        lmp.add((MessageProcessor)internalForeach);
        return lmp;
    }

    private Foreach createForeach(List<MessageProcessor> mps) throws MuleException {
        Foreach f = new Foreach();
        f.setMessageProcessors(mps);
        f.setMuleContext(muleContext);
        f.initialise();
        return f;
    }

    @Test
    public void testArrayListPayload() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("bar");
        arrayList.add("zip");
        this.simpleForeach.process(ForeachTestCase.getTestEvent(arrayList));
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void testArrayPayload() throws Exception {
        String[] array = new String[]{"bar", "zip"};
        this.simpleForeach.process(ForeachTestCase.getTestEvent(array));
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void testMuleMessageCollectionPayload() throws Exception {
        DefaultMessageCollection msgCollection = new DefaultMessageCollection(muleContext);
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"bar", muleContext);
        msgCollection.addMessage((MuleMessage)msg);
        msg = new DefaultMuleMessage((Object)"zip", muleContext);
        msgCollection.addMessage((MuleMessage)msg);
        this.simpleForeach.process(ForeachTestCase.getTestEvent(msgCollection));
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void testIterablePayload() throws Exception {
        DummySimpleIterableClass iterable = new DummySimpleIterableClass();
        this.simpleForeach.process(ForeachTestCase.getTestEvent(iterable));
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void testIteratorPayload() throws Exception {
        DummySimpleIterableClass iterable = new DummySimpleIterableClass();
        this.simpleForeach.process(ForeachTestCase.getTestEvent(iterable.iterator()));
        this.assertSimpleProcessedMessages();
    }

    @Test
    public void testNestedArrayListPayload() throws Exception {
        ArrayList payload = new ArrayList();
        ArrayList<String> elem1 = new ArrayList<String>();
        ArrayList<String> elem2 = new ArrayList<String>();
        ArrayList<String> elem3 = new ArrayList<String>();
        elem1.add("a1");
        elem1.add("a2");
        elem1.add("a3");
        elem2.add("b1");
        elem2.add("b2");
        elem3.add("c1");
        payload.add(elem1);
        payload.add(elem2);
        payload.add(elem3);
        this.nestedForeach.process(ForeachTestCase.getTestEvent(payload));
        this.assertNestedProcessedMessages();
    }

    @Test
    public void testNestedArrayPayload() throws Exception {
        String[][] payload = new String[3][2];
        payload[0][0] = "a1";
        payload[0][1] = "a2";
        payload[1][0] = "a3";
        payload[1][1] = "b1";
        payload[2][0] = "b2";
        payload[2][1] = "c1";
        this.nestedForeach.process(ForeachTestCase.getTestEvent(payload));
        this.assertNestedProcessedMessages();
    }

    @Test
    public void testNestedMuleMessageCollectionPayload() throws Exception {
        DefaultMessageCollection parentCollection = new DefaultMessageCollection(muleContext);
        DefaultMessageCollection childCollection1 = new DefaultMessageCollection(muleContext);
        DefaultMessageCollection childCollection2 = new DefaultMessageCollection(muleContext);
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"a1", muleContext);
        childCollection1.addMessage((MuleMessage)msg);
        msg = new DefaultMuleMessage((Object)"a2", muleContext);
        childCollection1.addMessage((MuleMessage)msg);
        msg = new DefaultMuleMessage((Object)"a3", muleContext);
        childCollection1.addMessage((MuleMessage)msg);
        msg = new DefaultMuleMessage((Object)"b1", muleContext);
        childCollection2.addMessage((MuleMessage)msg);
        msg = new DefaultMuleMessage((Object)"b2", muleContext);
        childCollection2.addMessage((MuleMessage)msg);
        msg = new DefaultMuleMessage((Object)"c1", muleContext);
        childCollection2.addMessage((MuleMessage)msg);
        parentCollection.addMessage((MuleMessage)childCollection1);
        parentCollection.addMessage((MuleMessage)childCollection2);
        this.nestedForeach.process(ForeachTestCase.getTestEvent(parentCollection));
        this.assertNestedProcessedMessages();
    }

    @Test
    public void testNestedIterablePayload() throws Exception {
        DummyNestedIterableClass iterable = new DummyNestedIterableClass();
        this.nestedForeach.process(ForeachTestCase.getTestEvent(iterable));
        this.assertNestedProcessedMessages();
    }

    @Test
    public void testNestedIteratorPayload() throws Exception {
        DummyNestedIterableClass iterable = new DummyNestedIterableClass();
        this.nestedForeach.process(ForeachTestCase.getTestEvent(iterable.iterator()));
        this.assertNestedProcessedMessages();
    }

    private void assertSimpleProcessedMessages() {
        Assert.assertEquals((String)ERR_NUMBER_MESSAGES, (long)2L, (long)this.processedEvents.size());
        Assert.assertTrue((String)ERR_PAYLOAD_TYPE, (boolean)(this.processedEvents.get(0).getMessage().getPayload() instanceof String));
        Assert.assertTrue((String)ERR_PAYLOAD_TYPE, (boolean)(this.processedEvents.get(1).getMessage().getPayload() instanceof String));
        Assert.assertEquals((String)ERR_OUTPUT, (Object)"bar:foo:zas", (Object)this.processedEvents.get(0).getMessage().getPayload());
        Assert.assertEquals((String)ERR_OUTPUT, (Object)"zip:foo:zas", (Object)this.processedEvents.get(1).getMessage().getPayload());
    }

    private void assertNestedProcessedMessages() {
        int i;
        String[] expectedOutputs = new String[]{"a1:foo:zas", "a2:foo:zas", "a3:foo:zas", "b1:foo:zas", "b2:foo:zas", "c1:foo:zas"};
        Assert.assertEquals((String)ERR_NUMBER_MESSAGES, (long)6L, (long)this.processedEvents.size());
        for (i = 0; i < this.processedEvents.size(); ++i) {
            Assert.assertTrue((String)ERR_PAYLOAD_TYPE, (boolean)(this.processedEvents.get(i).getMessage().getPayload() instanceof String));
        }
        for (i = 0; i < this.processedEvents.size(); ++i) {
            Assert.assertEquals((String)ERR_OUTPUT, (Object)expectedOutputs[i], (Object)this.processedEvents.get(i).getMessage().getPayload());
        }
    }

    private class DummyNestedIterableClass
    implements Iterable<DummySimpleIterableClass> {
        private ArrayList<DummySimpleIterableClass> iterables = new ArrayList();

        public DummyNestedIterableClass() {
            DummySimpleIterableClass dsi1 = new DummySimpleIterableClass();
            dsi1.strings = new ArrayList();
            dsi1.strings.add("a1");
            dsi1.strings.add("a2");
            DummySimpleIterableClass dsi2 = new DummySimpleIterableClass();
            dsi2.strings = new ArrayList();
            dsi2.strings.add("a3");
            dsi2.strings.add("b1");
            dsi2.strings.add("b2");
            dsi2.strings.add("c1");
            this.iterables.add(dsi1);
            this.iterables.add(dsi2);
        }

        @Override
        public Iterator<DummySimpleIterableClass> iterator() {
            return this.iterables.iterator();
        }
    }

    public class DummySimpleIterableClass
    implements Iterable<String> {
        public ArrayList<String> strings = new ArrayList();

        public DummySimpleIterableClass() {
            this.strings.add("bar");
            this.strings.add("zip");
        }

        @Override
        public Iterator<String> iterator() {
            return this.strings.iterator();
        }
    }
}

