/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.store.ListableObjectStore;
import org.mule.routing.AsynchronousUntilSuccessfulProcessingStrategy;
import org.mule.routing.UntilSuccessful;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.store.SimpleMemoryObjectStore;

public class UntilSuccessfulTestCase
extends AbstractMuleContextTestCase {
    private UntilSuccessful untilSuccessful;
    private ListableObjectStore<MuleEvent> objectStore;
    private ConfigurableMessageProcessor targetMessageProcessor;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.untilSuccessful = this.buildUntiSuccessful(1000L);
    }

    private UntilSuccessful buildUntiSuccessful(Long millisBetweenRetries) throws Exception {
        UntilSuccessful untilSuccessful = new UntilSuccessful();
        untilSuccessful.setMuleContext(muleContext);
        untilSuccessful.setFlowConstruct((FlowConstruct)UntilSuccessfulTestCase.getTestService());
        untilSuccessful.setMaxRetries(2);
        if (millisBetweenRetries != null) {
            untilSuccessful.setMillisBetweenRetries(millisBetweenRetries.longValue());
        }
        this.objectStore = new SimpleMemoryObjectStore();
        untilSuccessful.setObjectStore(this.objectStore);
        this.targetMessageProcessor = new ConfigurableMessageProcessor();
        untilSuccessful.addRoute((MessageProcessor)this.targetMessageProcessor);
        return untilSuccessful;
    }

    @Override
    protected void doTearDown() throws Exception {
        this.untilSuccessful.stop();
    }

    @Test
    public void testSuccessfulDelivery() throws Exception {
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("test_data");
        Assert.assertSame((Object)VoidMuleEvent.getInstance(), (Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventProcessed(testEvent);
    }

    @Test
    public void testSuccessfulDeliveryStreamPayload() throws Exception {
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent(new ByteArrayInputStream("test_data".getBytes()));
        Assert.assertSame((Object)VoidMuleEvent.getInstance(), (Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventProcessed(testEvent);
    }

    @Test
    @Ignore(value="MULE-6926: flaky test")
    public void testSuccessfulDeliveryAckExpression() throws Exception {
        this.untilSuccessful.setAckExpression("#[string:ACK]");
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("test_data");
        Assert.assertEquals((Object)"ACK", (Object)this.untilSuccessful.process(testEvent).getMessageAsString());
        this.ponderUntilEventProcessed(testEvent);
    }

    @Test
    public void testSuccessfulDeliveryFailureExpression() throws Exception {
        this.untilSuccessful.setFailureExpression("#[regex('(?i)error')]");
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("test_data");
        Assert.assertSame((Object)VoidMuleEvent.getInstance(), (Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventProcessed(testEvent);
    }

    @Test
    public void testPermanentDeliveryFailure() throws Exception {
        this.targetMessageProcessor.setNumberOfFailuresToSimulate(Integer.MAX_VALUE);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("ERROR");
        Assert.assertSame((Object)VoidMuleEvent.getInstance(), (Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventAborted(testEvent);
    }

    @Test
    public void testPermanentDeliveryFailureExpression() throws Exception {
        this.untilSuccessful.setFailureExpression("#[regex('(?i)error')]");
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("ERROR");
        Assert.assertSame((Object)VoidMuleEvent.getInstance(), (Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventAborted(testEvent);
    }

    @Test
    public void testPermanentDeliveryFailureDLQ() throws Exception {
        this.targetMessageProcessor.setNumberOfFailuresToSimulate(Integer.MAX_VALUE);
        EndpointBuilder dlqEndpointBuilder = (EndpointBuilder)Mockito.mock(EndpointBuilder.class);
        OutboundEndpoint dlqEndpoint = (OutboundEndpoint)Mockito.mock(OutboundEndpoint.class);
        Mockito.when((Object)dlqEndpointBuilder.buildOutboundEndpoint()).thenReturn((Object)dlqEndpoint);
        this.untilSuccessful.setDeadLetterQueue((Object)dlqEndpointBuilder);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("ERROR");
        Assert.assertSame((Object)VoidMuleEvent.getInstance(), (Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventAborted(testEvent);
        ((OutboundEndpoint)Mockito.verify((Object)dlqEndpoint)).process((MuleEvent)Matchers.any(MuleEvent.class));
    }

    @Test
    public void testTemporaryDeliveryFailure() throws Exception {
        this.targetMessageProcessor.setNumberOfFailuresToSimulate(this.untilSuccessful.getMaxRetries());
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("ERROR");
        Assert.assertSame((Object)VoidMuleEvent.getInstance(), (Object)this.untilSuccessful.process(testEvent));
        this.ponderUntilEventProcessed(testEvent);
        Assert.assertEquals((long)this.targetMessageProcessor.getEventCount(), (long)(this.untilSuccessful.getMaxRetries() + 1));
    }

    @Test
    public void testPreExistingEvents() throws Exception {
        MuleEvent testEvent = UntilSuccessfulTestCase.getTestEvent("test_data");
        new AsynchronousUntilSuccessfulProcessingStrategy();
        this.objectStore.store(AsynchronousUntilSuccessfulProcessingStrategy.buildQueueKey((MuleEvent)testEvent), (Serializable)testEvent);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        this.ponderUntilEventProcessed(testEvent);
    }

    @Test
    public void testDefaultMillisWait() throws Exception {
        this.untilSuccessful = this.buildUntiSuccessful(null);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        Assert.assertEquals((long)60000L, (long)this.untilSuccessful.getMillisBetweenRetries());
    }

    @Test
    public void testMillisWait() throws Exception {
        long millis = 10L;
        this.untilSuccessful.setMillisBetweenRetries(10L);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        Assert.assertEquals((long)10L, (long)this.untilSuccessful.getMillisBetweenRetries());
    }

    @Test
    public void testSecondsWait() throws Exception {
        long seconds = 10L;
        this.untilSuccessful = this.buildUntiSuccessful(null);
        this.untilSuccessful.setSecondsBetweenRetries(10L);
        this.untilSuccessful.initialise();
        this.untilSuccessful.start();
        Assert.assertEquals((long)10000L, (long)this.untilSuccessful.getMillisBetweenRetries());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMillisAndSecondsWait() throws Exception {
        this.untilSuccessful.setMillisBetweenRetries(1000L);
        this.untilSuccessful.setSecondsBetweenRetries(1000L);
        this.untilSuccessful.initialise();
    }

    private void ponderUntilEventProcessed(MuleEvent testEvent) throws InterruptedException, MuleException {
        while (this.targetMessageProcessor.getEventReceived() == null) {
            Thread.yield();
            Thread.sleep(250L);
        }
        Assert.assertEquals((long)0L, (long)this.objectStore.allKeys().size());
        this.assertLogicallyEqualEvents(testEvent, this.targetMessageProcessor.getEventReceived());
    }

    private void ponderUntilEventAborted(MuleEvent testEvent) throws InterruptedException, MuleException {
        while (this.targetMessageProcessor.getEventCount() <= this.untilSuccessful.getMaxRetries()) {
            Thread.yield();
            Thread.sleep(250L);
        }
        Assert.assertEquals((long)0L, (long)this.objectStore.allKeys().size());
        Assert.assertEquals((long)this.targetMessageProcessor.getEventCount(), (long)(1 + this.untilSuccessful.getMaxRetries()));
    }

    private void assertLogicallyEqualEvents(MuleEvent testEvent, MuleEvent eventReceived) throws MuleException {
        Assert.assertEquals((Object)testEvent.getMessage().getCorrelationId(), (Object)eventReceived.getMessage().getCorrelationId());
        Assert.assertEquals((Object)testEvent.getMessageAsString(), (Object)eventReceived.getMessageAsString());
    }

    public static class ConfigurableMessageProcessor
    implements MessageProcessor {
        private volatile int eventCount;
        private volatile MuleEvent event;
        private volatile int numberOfFailuresToSimulate;

        public MuleEvent process(MuleEvent evt) throws MuleException {
            ++this.eventCount;
            if (this.numberOfFailuresToSimulate-- > 0) {
                throw new RuntimeException("simulated problem");
            }
            this.event = evt;
            return evt;
        }

        public MuleEvent getEventReceived() {
            return this.event;
        }

        public int getEventCount() {
            return this.eventCount;
        }

        public void setNumberOfFailuresToSimulate(int numberOfFailuresToSimulate) {
            this.numberOfFailuresToSimulate = numberOfFailuresToSimulate;
        }
    }
}

