/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transaction.TransactionFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transaction.TransactionCoordination;

public class IsTransactedTestCase
extends AbstractMuleTestCase {
    @Test
    public void testIsTransacted() throws Exception {
        MuleTransactionConfig cfg = new MuleTransactionConfig();
        TestTransaction testTx = new TestTransaction(null);
        cfg.setAction((byte)5);
        Assert.assertFalse((boolean)cfg.isTransacted());
        cfg.setAction((byte)5);
        Assert.assertFalse((boolean)cfg.isTransacted());
        cfg.setFactory((TransactionFactory)new TransactedFactory());
        cfg.setAction((byte)1);
        Assert.assertTrue((boolean)cfg.isTransacted());
        cfg.setAction((byte)3);
        Assert.assertTrue((boolean)cfg.isTransacted());
        cfg.setAction((byte)2);
        Assert.assertTrue((boolean)cfg.isTransacted());
        cfg.setAction((byte)4);
        Assert.assertFalse((boolean)cfg.isTransacted());
        TransactionCoordination.getInstance().bindTransaction((Transaction)testTx);
        Assert.assertTrue((boolean)cfg.isTransacted());
        TransactionCoordination.getInstance().unbindTransaction((Transaction)testTx);
        cfg.setAction((byte)6);
        Assert.assertFalse((boolean)cfg.isTransacted());
        TransactionCoordination.getInstance().bindTransaction((Transaction)testTx);
        Assert.assertTrue((boolean)cfg.isTransacted());
        TransactionCoordination.getInstance().unbindTransaction((Transaction)testTx);
        cfg.setFactory((TransactionFactory)new NonTransactedFactory());
        cfg.setAction((byte)1);
        Assert.assertFalse((boolean)cfg.isTransacted());
        cfg.setAction((byte)3);
        Assert.assertFalse((boolean)cfg.isTransacted());
        cfg.setAction((byte)2);
        Assert.assertFalse((boolean)cfg.isTransacted());
        cfg.setAction((byte)4);
        Assert.assertFalse((boolean)cfg.isTransacted());
        TransactionCoordination.getInstance().bindTransaction((Transaction)testTx);
        Assert.assertFalse((boolean)cfg.isTransacted());
        TransactionCoordination.getInstance().unbindTransaction((Transaction)testTx);
        cfg.setAction((byte)6);
        Assert.assertFalse((boolean)cfg.isTransacted());
        TransactionCoordination.getInstance().bindTransaction((Transaction)testTx);
        Assert.assertFalse((boolean)cfg.isTransacted());
        TransactionCoordination.getInstance().unbindTransaction((Transaction)testTx);
    }

    @Test(expected=MuleRuntimeException.class)
    public void testExpectException1() {
        MuleTransactionConfig cfg = new MuleTransactionConfig(1);
        cfg.isTransacted();
    }

    @Test(expected=MuleRuntimeException.class)
    public void testExpectException2() {
        MuleTransactionConfig cfg = new MuleTransactionConfig(4);
        cfg.isTransacted();
    }

    public static class NonTransactedFactory
    implements TransactionFactory {
        public Transaction beginTransaction(MuleContext muleContext) throws TransactionException {
            return null;
        }

        public boolean isTransacted() {
            return false;
        }
    }

    public static class TransactedFactory
    implements TransactionFactory {
        public Transaction beginTransaction(MuleContext muleContext) throws TransactionException {
            return null;
        }

        public boolean isTransacted() {
            return true;
        }
    }
}

