/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.Serializable;
import org.apache.commons.lang.NotImplementedException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.api.MuleEvent;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.MuleContextBuilder;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.journal.queue.LocalTxQueueTransactionJournal;
import org.mule.util.journal.queue.LocalTxQueueTransactionRecoverer;
import org.mule.util.queue.DefaultQueueConfiguration;
import org.mule.util.queue.DefaultQueueStore;
import org.mule.util.queue.PersistentQueueTransactionContext;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueProvider;
import org.mule.util.queue.QueueStore;
import org.mule.util.queue.RecoverableQueueStore;
import org.mule.util.queue.TestTransactionLogger;
import org.mule.util.xa.ResourceManagerException;

public class LocalTxQueueTransactionRecovererTestCase
extends AbstractMuleContextTestCase {
    public static final String QUEUE_NAME = "inQueue";
    public static final String MESSAGE_CONTENT = "data";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private DefaultQueueStore inQueue;

    @Override
    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
        DefaultMuleConfiguration muleConfiguration = new DefaultMuleConfiguration();
        muleConfiguration.setWorkingDirectory(this.temporaryFolder.getRoot().getAbsolutePath());
        contextBuilder.setMuleConfiguration((MuleConfiguration)muleConfiguration);
    }

    @Test
    public void pollAndFailThenRecover() throws Exception {
        ((DefaultMuleConfiguration)muleContext.getConfiguration()).setWorkingDirectory(this.temporaryFolder.getRoot().getAbsolutePath());
        LocalTxQueueTransactionJournal txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        this.inQueue = new DefaultQueueStore(QUEUE_NAME, muleContext, (QueueConfiguration)new DefaultQueueConfiguration(0, true));
        PersistentQueueTransactionContext persistentTransactionContext = new PersistentQueueTransactionContext(txLog, this.createQueueProvider(this.inQueue));
        MuleEvent testEvent = LocalTxQueueTransactionRecovererTestCase.getTestEvent(MESSAGE_CONTENT);
        this.inQueue.offer((Serializable)testEvent, 0, 10L);
        Serializable value = persistentTransactionContext.poll((QueueStore)this.inQueue, 100000L);
        Assert.assertThat((Object)this.inQueue.poll(10L), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)value, (Matcher)IsNull.notNullValue());
        txLog.close();
        txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        LocalTxQueueTransactionRecoverer queueTransactionRecoverer = new LocalTxQueueTransactionRecoverer(txLog, this.createQueueProvider(this.inQueue));
        queueTransactionRecoverer.recover();
        Serializable muleEvent = this.inQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)testEvent.equals(muleEvent), (Matcher)Is.is((Object)true));
    }

    @Test
    public void failBetweenLogEntryWriteAndRealPoolThenRecover() throws Exception {
        ((DefaultMuleConfiguration)muleContext.getConfiguration()).setWorkingDirectory(this.temporaryFolder.getRoot().getAbsolutePath());
        LocalTxQueueTransactionJournal txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        DefaultQueueStore inQueue = new DefaultQueueStore(QUEUE_NAME, muleContext, (QueueConfiguration)new DefaultQueueConfiguration(0, true));
        PersistentQueueTransactionContext persistentTransactionContext = new PersistentQueueTransactionContext(txLog, this.createQueueProvider(inQueue));
        MuleEvent testEvent = LocalTxQueueTransactionRecovererTestCase.getTestEvent(MESSAGE_CONTENT);
        inQueue.offer((Serializable)testEvent, 0, 10L);
        persistentTransactionContext.poll((QueueStore)inQueue, 10L);
        txLog.close();
        txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        LocalTxQueueTransactionRecoverer queueTransactionRecoverer = new LocalTxQueueTransactionRecoverer(txLog, this.createQueueProvider(inQueue));
        queueTransactionRecoverer.recover();
        Serializable muleEvent = inQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)testEvent.equals(muleEvent), (Matcher)Is.is((Object)true));
        muleEvent = inQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.nullValue());
    }

    private QueueProvider createQueueProvider(final DefaultQueueStore queue) {
        return new QueueProvider(){

            public QueueStore getQueue(String queueName) {
                throw new NotImplementedException();
            }

            public RecoverableQueueStore getRecoveryQueue(String queueName) {
                return queue;
            }
        };
    }

    @Test
    public void offerAndFailThenRecover() throws Exception {
        ((DefaultMuleConfiguration)muleContext.getConfiguration()).setWorkingDirectory(this.temporaryFolder.getRoot().getAbsolutePath());
        LocalTxQueueTransactionJournal txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        DefaultQueueStore outQueue = new DefaultQueueStore(QUEUE_NAME, muleContext, (QueueConfiguration)new DefaultQueueConfiguration(0, true));
        PersistentQueueTransactionContext persistentTransactionContext = new PersistentQueueTransactionContext(txLog, this.createQueueProvider(outQueue));
        MuleEvent testEvent = LocalTxQueueTransactionRecovererTestCase.getTestEvent(MESSAGE_CONTENT);
        persistentTransactionContext.offer((QueueStore)outQueue, (Serializable)testEvent, 10L);
        Assert.assertThat((Object)outQueue.poll(10L), (Matcher)IsNull.nullValue());
        txLog.close();
        txLog = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        LocalTxQueueTransactionRecoverer queueTransactionRecoverer = new LocalTxQueueTransactionRecoverer(txLog, this.createQueueProvider(outQueue));
        queueTransactionRecoverer.recover();
        Serializable muleEvent = outQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.nullValue());
    }

    @Test
    public void offerAndFailBetweenRealOfferAndCommitThenRecover() throws Exception {
        ((DefaultMuleConfiguration)muleContext.getConfiguration()).setWorkingDirectory(this.temporaryFolder.getRoot().getAbsolutePath());
        TestTransactionLogger txLog = new TestTransactionLogger(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext).failDuringLogCommit();
        DefaultQueueStore outQueue = new DefaultQueueStore(QUEUE_NAME, muleContext, (QueueConfiguration)new DefaultQueueConfiguration(0, true));
        PersistentQueueTransactionContext persistentTransactionContext = new PersistentQueueTransactionContext((LocalTxQueueTransactionJournal)txLog, this.createQueueProvider(outQueue));
        MuleEvent testEvent = LocalTxQueueTransactionRecovererTestCase.getTestEvent(MESSAGE_CONTENT);
        persistentTransactionContext.offer((QueueStore)outQueue, (Serializable)testEvent, 10L);
        try {
            persistentTransactionContext.doCommit();
            Assert.fail();
        }
        catch (ResourceManagerException e) {
            // empty catch block
        }
        txLog.close();
        txLog = new TestTransactionLogger(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        LocalTxQueueTransactionRecoverer queueTransactionRecoverer = new LocalTxQueueTransactionRecoverer((LocalTxQueueTransactionJournal)txLog, this.createQueueProvider(outQueue));
        queueTransactionRecoverer.recover();
        Serializable muleEvent = outQueue.poll(10L);
        Assert.assertThat((Object)muleEvent, (Matcher)IsNull.nullValue());
    }
}

