/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.blueprint;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.apache.cxf.configuration.blueprint.AbstractBPBeanDefinitionParser;
import org.apache.cxf.configuration.jsse.spring.TLSClientParametersConfig;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpConduitBPBeanDefinitionParser
extends AbstractBPBeanDefinitionParser {
    private static final String HTTP_NS = "http://cxf.apache.org/transports/http/configuration";

    public Metadata parse(Element element, ParserContext context) {
        MutableBeanMetadata bean = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        bean.setRuntimeClass(HTTPConduit.class);
        this.mapElementToJaxbProperty(context, bean, element, new QName(HTTP_NS, "client"), "client", HTTPClientPolicy.class);
        this.mapElementToJaxbProperty(context, bean, element, new QName(HTTP_NS, "proxyAuthorization"), "proxyAuthorization", ProxyAuthorizationPolicy.class);
        this.mapElementToJaxbProperty(context, bean, element, new QName(HTTP_NS, "authorization"), "authorization", AuthorizationPolicy.class);
        this.parseAttributes(element, context, bean);
        this.parseChildElements(element, context, bean);
        bean.setScope("prototype");
        return bean;
    }

    protected void processNameAttribute(Element element, ParserContext context, MutableBeanMetadata bean, String val) {
        bean.setId(val);
    }

    protected void mapElement(ParserContext ctx, MutableBeanMetadata bean, Element el, String name) {
        if ("tlsClientParameters".equals(name)) {
            this.mapTLSClientParameters(ctx, bean, el);
        } else if ("trustDecider".equals(name)) {
            this.mapBeanOrClassElement(ctx, bean, el, MessageTrustDecider.class);
        } else if ("authSupplier".equals(name)) {
            this.mapBeanOrClassElement(ctx, bean, el, HttpAuthSupplier.class);
        }
    }

    private void mapTLSClientParameters(ParserContext ctx, MutableBeanMetadata bean, Element el) {
        StringWriter writer = new StringWriter();
        XMLStreamWriter xmlWriter = StaxUtils.createXMLStreamWriter((Writer)writer);
        try {
            StaxUtils.copy((Element)el, (XMLStreamWriter)xmlWriter);
            xmlWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        Object v = TLSClientParametersConfig.createTLSClientParameters(writer.toString());
        MutablePassThroughMetadata value = (MutablePassThroughMetadata)ctx.createMetadata(MutablePassThroughMetadata.class);
        value.setObject(v);
        bean.addProperty("tlsClientParameters", (Metadata)value);
    }

    private void mapBeanOrClassElement(ParserContext ctx, MutableBeanMetadata bean, Element el, Class<?> cls) {
        String elementName = el.getLocalName();
        String classProperty = el.getAttribute("class");
        String beanref = el.getAttribute("bean");
        if (classProperty != null && !classProperty.equals("")) {
            bean.addProperty(elementName, (Metadata)HttpConduitBPBeanDefinitionParser.createObjectOfClass((ParserContext)ctx, (String)classProperty));
        } else if (beanref != null && !beanref.equals("")) {
            bean.addProperty(elementName, (Metadata)HttpConduitBPBeanDefinitionParser.createRef((ParserContext)ctx, (String)beanref));
        }
    }
}

